% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{removeSpectrum}
\alias{removeSpectrum}
\title{A function for removing a spectrum.}
\usage{
removeSpectrum(
  mrbinResults = NULL,
  spectra = NULL,
  verbose = TRUE,
  errorsAsWarnings = FALSE,
  graphics = TRUE
)
}
\arguments{
\item{mrbinResults}{An mrbin object. If not provided, the function works on the package environment}

\item{spectra}{Character vector with NMR folder names to be excluded. If provided, no interactive selection will be shown}

\item{verbose}{Should a summary be printed?}

\item{errorsAsWarnings}{If TRUE, errors will be turned into warnings. Should be used with care, as errors indicate undocumented changes to the data.}

\item{graphics}{Controls whether pop-up windows are shown for selections. Defaults to TRUE.}
}
\value{
An invisible mrbin object (only if an mrbin object was provided)
}
\description{
This function lets the user pick spectra from a list for removal from data
analysis.
}
\examples{
results<-mrbin(silent=TRUE,setDefault=TRUE,parameters=list(dimension="1D",
         binwidth1D=0.05,PQNScaling="No",PCA="No",tryParallel=TRUE,logTrafo="No",
         noiseRemoval="No",
         NMRfolders=c(system.file("extdata/1/10/pdata/10",package="mrbin"),
                      system.file("extdata/2/10/pdata/10",package="mrbin"),
                      system.file("extdata/3/10/pdata/10",package="mrbin"))))
results<-removeSpectrum(results,
 spectra=c(system.file("extdata/2/10/pdata/10",package="mrbin")))
}
