\name{dht.deriv}
\alias{dht.deriv}
\title{Computes abundance estimates at specified parameter values using
Horvitz-Thompson-like estimator}
\usage{
  dht.deriv(par, model, obs, samples, options = list())
}
\arguments{
  \item{par}{detection function parameter values}

  \item{model}{ddf model object}

  \item{obs}{observations table}

  \item{samples}{samples table}

  \item{options}{list of options as specified in
  \code{\link{dht}}}
}
\value{
  vector of abundance estimates at values of parameters
  specified in par
}
\description{
  Computes abundance at specified values of parameters for
  numerical computation of first derivative with respect to
  parameters in detection function.  An internal function
  called by DeltaMethod which is invoked by dht.se
}
\note{
  Internal function; not intended to be called by user
}
\author{
  Jeff Laake
}
\seealso{
  \code{\link{dht}}, \code{\link{dht.se}},
  \code{\link{DeltaMethod}}
}
\keyword{utility}

