% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrfi_methods.R
\name{plot.mrfi}
\alias{plot.mrfi}
\alias{mrfi-plot}
\title{Plotting of \code{mrfi} objects.}
\usage{
\method{plot}{mrfi}(x, include_axis = FALSE, include_opposite = TRUE, ...)
}
\arguments{
\item{x}{A \code{\link[=mrfi-class]{mrfi}} object.}

\item{include_axis}{\code{logical} indicating whether the axis and grid lines
are included. If \code{FALSE} \code{theme_void()} is added to the \code{ggplot} object.}

\item{include_opposite}{´logical` whether opposite directions should be
included in the visualization of the dependence structure.}

\item{...}{other arguments not used by this method.}
}
\value{
A \code{ggplot} object using \code{geom_tile()} to represent interacting
relative positions.
}
\description{
Plots a visual representation of the interaction structure
described in a \code{mrfi} object. The black tile represents a reference pixel
and gray tiles are shown in relative positions with dependent pixels.

A \code{ggplot} object is used, therefore, the user can load the \code{ggplot2}
package and add more \code{ggplot} layers to freely customize the \code{plot}.
}
\details{
The \code{data.frame} used for the \code{ggplot} call has columns names \code{rx}
and \code{ry} repŕesenting the relative positions.
}
\examples{
plot(mrfi(1))

library(ggplot2)
plot(mrfi(1)) + geom_tile(fill = "red")
plot(mrfi(1)) + geom_tile(fill = "blue") + theme_void()

plot(mrfi(1)) + geom_text(aes(label = paste0("(",rx,",",ry,")")))

}
\author{
Victor Freguglia
}
