% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\alias{render,character-method}
\alias{render,mrgmod-method}
\alias{dorender}
\title{Render a model to a document}
\usage{
render(x, ...)

\S4method{render}{character}(x, project = NULL, ...)

\S4method{render}{mrgmod}(x, ...)

dorender(model, project, template = NULL, compile = TRUE, ...)
}
\arguments{
\item{x}{model object or the model name}

\item{...}{passed to \code{rmarkdown::render}}

\item{project}{the directory containing the \code{.cpp} model file}

\item{model}{model name}

\item{template}{template document}

\item{compile}{logical; if true, the model will be compiled to run}
}
\description{
Render a model to a document
}
\examples{
\dontrun{
mod <- mrgsolve::house()
mrgsolve:::render(mod)
mrgsolve:::render("irm2", modlib())
}

}
