% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sde.prior.R
\name{sde.prior}
\alias{sde.prior}
\title{SDE prior function.}
\usage{
sde.prior(model, theta, x, hyper)
}
\arguments{
\item{model}{An \code{sde.model} object.}

\item{theta}{A vector or matrix of parameters with \code{nparams} columns.}

\item{x}{A vector or matrix of data with \code{ndims} columns.}

\item{hyper}{The hyperparameters of the SDE prior.  See Details.}
}
\value{
A vector of log-prior densities evaluated at the inputs.
}
\description{
Evaluates the SDE prior given data, parameter, and hyperparameter values.
}
\details{
The prior is constructed at the \code{C++} level by defining a function (i.e., public member) \cr \code{double logPrior(double *theta, double *x)} within the \code{sdePrior} class.  At the \code{R} level, the \code{hyper.check} argument of \code{sde.make.model} is a function with arguments \code{hyper}, \code{param.names}, \code{data.names} used to convert \code{hyper} into a list of \code{NULL} or double-vectors which get passed on to the \code{C++} code.  This function can also be used to throw \code{R}-level errors to protect the \code{C++} code from invalid inputs, as is done for the default prior in \code{\link{mvn.hyper.check}}.  For a full example see the "Custom Prior" section in \code{vignette("msde-quicktut")}.
}
\examples{
hmod <- sde.examples("hest") # load Heston's model

# setting prior for 3 parameters
rv.names <- c("alpha","gamma","rho")
mu <- rnorm(3)
Sigma <- crossprod(matrix(rnorm(9),3,3))
names(mu) <- rv.names
colnames(Sigma) <- rv.names
rownames(Sigma) <- rv.names
hyper <- list(mu = mu, Sigma = Sigma)

# Simulate data
nreps <- 10
theta <- c(alpha = 0.1, gamma = 1, beta = 0.8, sigma = 0.6, rho = -0.8)
x0 <- c(X = log(1000), Z = 0.1)
Theta <- apply(t(replicate(nreps,theta)),2,jitter)
X0 <- apply(t(replicate(nreps,x0)),2,jitter)

sde.prior(model = hmod, x = X0, theta = Theta, hyper = hyper)
}
