% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstDIF-class_methods.R
\name{mstDIF-Methods}
\alias{mstDIF-Methods}
\alias{print.mstDIF}
\alias{summary.mstDIF}
\title{Methods for the mstDIF-class}
\usage{
\method{print}{mstDIF}(x, ...)

\method{summary}{mstDIF}(object, DIF_type = "overall", ordered = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{mstDIF}}

\item{...}{other arguments passed to the method.}

\item{object}{an object of class \code{mstDIF}}

\item{DIF_type}{a string that should one or more of "overall", "uniform",
"non-uniform", "all".}

\item{ordered}{logical: should the summary be ordered according to the obtained p-values (in ascending order)?}
}
\description{
\code{print} and \code{summary} methods for objects of the
\code{mstDIF-class}, as returned by \code{\link{mstDIF}}. See details
for more information about the methods.
}
\details{
The \code{print} method prints some basic information about the
  \code{mstDIF-class} object.

The \code{summary} method computes a data frame with a row for each item
that was included in the test. The columns are:
  \describe{
     \item{item}{The name of the item}
     \item{statistic}{The value for the used statistic per item}
     \item{p_value}{The p-value per item}
     \item{eff_size}{An effect-size for the DIF-test, if applicable}
   }
}
\examples{

## load data
data("toydata")

## fit 2PL model using mirt
mirt_model <- mirt::mirt(toydata$resp, model = 1)

## test DIF along a contiuous covariate
DIFtest <- mstDIF(mirt_model, DIF_covariate = toydata$group_cont,
method = "analytical")

## print
DIFtest

## summary
summary(DIFtest)


}
