% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\docType{class}
\name{Report}
\alias{Report}
\title{Extract a MicroStrategy report into a R Data.Frame}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Report
}
\description{
Access, filter, publish, and extract data from in-memory reports.
Create a Report object to load basic information on a report dataset. Specify subset of report
to be fetched through Report.apply_filters() and Report.clear_filters() . Fetch dataset through
Report.to_dataframe() method.
}
\section{Fields}{

\describe{
\item{\code{connection}}{MicroStrategy connection object}

\item{\code{report_id}}{Identifier of a pre-existing report.}
}}

\examples{
\donttest{
my_report <- Report$new(connection=conn, report_id="...")
df <- my_report$to_dataframe()
# Use object IDs for metrics, attributes, and attribute elements to filter contents of a report.
my_report$metrics
my_report$attributes
my_report$attr_elements

# Then, choose those elements by passing their IDs to the Report.apply_filters() method. 
# To see the chosen elements, call my_report.filters and to clear any active filters, 
# call my_report.clear_filters().
my_report$apply_filters(
         attributes=list("A598372E11E9910D1CBF0080EFD54D63", "A59855D811E9910D1CC50080EFD54D63"),
         metrics = list("B4054F5411E9910D672E0080EFC5AE5B"),
         attr_elements = list("A598372E11E9910D1CBF0080EFD54D63:Los Angeles", 
                              "A598372E11E9910D1CBF0080EFD54D63:Seattle"))
df <- my_report$to_dataframe()
}
}
\keyword{datasets}
