% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHVT.R
\name{plotHVT}
\alias{plotHVT}
\title{plotHVT}
\usage{
plotHVT(hvt.results, line.width, color.vec, pch1 = 19, centroid.size = 3,
  title = NULL)
}
\arguments{
\item{hvt.results}{List. A list containing the ouput of \code{HVT} function
which has the details of the tessellations to be plotted.}

\item{line.width}{Numeric Vector. A vector indicating the line widths of the
tessellation boundaries for each level.}

\item{color.vec}{Vector. A vector indicating the colors of the boundaries of
the tessellations at each level.}

\item{pch1}{Numeric. Symbol type of the centroids of the tessellations
(parent levels). Refer \code{\link{points}}. (default = 19)}

\item{centroid.size}{Numeric. Size of centroids of first level
tessellations. (default = 3)}

\item{title}{String. Set a title for the plot. (default = NULL)}
}
\description{
Plot the hierarchical tesselations.
}
\examples{


data("iris",package="datasets")
iris <- iris[,1:2]
hvt.results <- list()
hvt.results <- HVT(iris, nclust = 6, depth = 1, quant.err = 0.2, 
projection.scale = 10, normalize = TRUE)

plotHVT(hvt.results, line.width = c(3), color.vec = c("blue"))

hvt.results <- list()
hvt.results <- HVT(iris, nclust = 6, depth = 3, quant.err = 0.2, 
projection.scale = 10, normalize = TRUE)


plotHVT(hvt.results, line.width = c(4,3), color.vec = c("red", "green"))


}
\seealso{
\code{\link{HVT}} \cr \code{\link{hvtHmap}}
}
\author{
Meet K. Dave <dave.kirankumar@mu-sigma.com>
}
\keyword{hplot}
