% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{expand.tags}
\alias{expand.tags}
\alias{expand.tags.data.frame}
\alias{expand.tags.mudata}
\title{Expand JSON to multiple columns}
\usage{
expand.tags(x, ...)

\method{expand.tags}{data.frame}(x, tagcolumn = "tags", lazy = FALSE, ...)

\method{expand.tags}{mudata}(x, ...)
}
\arguments{
\item{x}{a vector of JSON values or a data.frame with a 'tags' column}

\item{...}{Passed to/from methods}

\item{tagcolumn}{the column containing json}

\item{lazy}{Don't preform expantion if tagcolumn exists in \code{x}}
}
\value{
A data.frame with columns added
}
\description{
Expands a character vector of JSON values or a data.frame with a column
\code{tagcolumn} to a data.frame with columns for each key in the
vector of JSON objects. If x is a mudata object, the operation will
be performed on the entire object.
}
\examples{
data(pocmaj)
condensed <- condense.tags(pocmaj, tagcolumns = c("Ca", "Ti", "V"))
expand.tags(condensed)

}
