% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{longbiplot}
\alias{biplot.qtag.long}
\alias{biplot.qtag.wide}
\alias{longbiplot}
\title{Biplot a molten data frame using facets}
\usage{
longbiplot(x, id.vars, measure.var, namesx = NULL, namesy = NULL,
  namecolumn = NULL, errors = NULL, labeller = ggplot2::label_value,
  validate = TRUE, ...)

\method{biplot}{qtag.long}(x, ...)

\method{biplot}{qtag.wide}(x, ...)
}
\arguments{
\item{x}{the object to biplot}

\item{id.vars}{the columns that identify a single value}

\item{measure.var}{The column containing the values to plot}

\item{namesx}{The names to be included in the x axes, or all the names to be included}

\item{namesy}{The names to be included on the y axes, or NULL for all possible combinations
of \code{namesx}.}

\item{namecolumn}{The column where namesx and namesy are to be found}

\item{errors}{The column containing the errors. Use \code{NULL} for default ("err" if column
exists or none otherwise), or \code{NA} to suppress.}

\item{labeller}{The labeller to use to label facets (may want to use \code{label_parsed}
to use plotmath-style labels)}

\item{validate}{Ensure id.vars identify unique values}

\item{...}{passed to \code{aes_string()}}
}
\description{
Uses the ggplot framework and \code{facet_grid} to produce biplots of a molten
data frame.
}
\examples{
data(pocmaj)
qt <- as.qtag(pocmaj)
biplot(qt, color="core")

}

