% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{read_gmt}
\alias{read_gmt}
\title{Read GMT File}
\usage{
read_gmt(file)
}
\arguments{
\item{file}{Character, a path to a file.}
}
\value{
Returns a \code{data.frame} with three columns:
\itemize{
\item 'ontology_id': Ontology identifier that uniquely identifies the element
within the referenced ontology.
\item 'ontology_name': Ontology name or description that provides a
user-friendly label or textual description for the 'ontology_id'.
\item 'list_of_values': Associated genes or proteins that is a vector of
identifiers of genes or proteins belonging to the 'ontology_id'.
}
}
\description{
Reads gene set or ontology data from a Gene Matrix Transposed
(GMT) file and parse into a \code{data.frame}.
}
\examples{
# import example gene set
library(mulea)
tf_gmt <- read_gmt(file = system.file(
    package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
}
