% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericFunctions.R, R/ORA.R
\name{run_test}
\alias{run_test}
\alias{run_test,ora-method}
\title{Run enrichment analysis procedure}
\usage{
run_test(model)

\S4method{run_test}{ora}(model)
}
\arguments{
\item{model}{Object of S4 class representing the mulea test.}
}
\value{
Results in form of \code{data.frame}. Structure of \code{data.frame} depends on
object processed by this generic method.
In the case of \code{run_test} was used with the model generated
by the \code{ora} function the returned
\code{data.frame} contains the following columns:
\enumerate{
\item 'ontology_id': Identifiers of the ontology elements.
\item 'ontology_name': Names of the ontology elements.
\item 'nr_common_with_tested_elements': Number of common elements between the
ontology element and the vector defined by the element_names parameter
of the \code{ora} function.
\item 'nr_common_with_background_elements': Number of common elements between
the ontology element and the vector defined by the
background_element_names parameter of the \code{ora} function.
\item 'p_value': The raw \emph{p}-value of the overrepresentation analysis.
\item The adjusted \emph{p}-value.
The column named based on the
p_value_adjustment_method parameter of the
\code{ora} function, \emph{e.g.} 'eFDR'
}

In the case of \code{run_test} was used with the model
generated by the \code{gsea} function the returned
\code{data.frame} contains the following columns:
\enumerate{
\item 'ontology_id': Identifiers of the ontology elements.
\item 'ontology_name': Names of the ontology elements.
\item 'nr_common_with_tested_elements': Number of common elements between the
ontology element and the vector defined by the element_names parameter
of the \code{gsea} function.
\item 'p_value': The raw \emph{p}-value of the gene set enrichment analysis.
\item 'adjusted_p_value': The adjusted \emph{p}-value.
}

run_test method for ora object. Returns the results of the
overrepresentation analysis.
}
\description{
This is a generic function that chooses an enrichment analysis procedure
based on the model class and runs the analysis.
}
\details{
The function requires the definition of a model. Models currently
implemented in mulea include Gene Set Enrichment Analysis (GSEA) and
Over-Representation Analysis (ORA). These models must be defined through
their specific functions which are provided in this package.
}
\section{Methods (by class)}{
\itemize{
\item \code{run_test(ora)}: ora test.

}}
\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file( package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
    max_nr_of_elements = 400)

# loading the example data
sign_genes <- readLines(system.file(package = "mulea", "extdata", 
    "target_set.txt"))
background_genes <- readLines(system.file(package="mulea", "extdata", "
    background_set.txt"))

# creating the ORA model
ora_model <- ora(gmt = tf_gmt_filtered, 
    # the test set variable
    element_names = sign_genes, 
    # the background set variable
    background_element_names = background_genes, 
    # the p-value adjustment method
    p_value_adjustment_method = "eFDR", 
    # the number of permutations
    number_of_permutations = 10000,
    # the number of processor threads to use
    nthreads = 2)
# running the ORA
ora_results <- run_test(ora_model)

library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(
        package="mulea", "extdata", 
        "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
        max_nr_of_elements = 400)

# loading the example data
sign_genes <- readLines(system.file(package = "mulea", "extdata", 
        "target_set.txt"))
background_genes <- readLines(system.file(package="mulea", "extdata", 
        "background_set.txt"))

# creating the ORA model
ora_model <- ora(gmt = tf_gmt_filtered, 
        # the test set variable
        element_names = sign_genes, 
        # the background set variable
        background_element_names = background_genes, 
        # the p-value adjustment method
        p_value_adjustment_method = "eFDR", 
        # the number of permutations
        number_of_permutations = 10000,
        # the number of processor threads to use
        nthreads = 2)
# running the ORA
ora_results <- run_test(ora_model)
}
\seealso{
\code{\link{gsea}}, \code{\link{ora}}
}
