% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{pooled_vc}
\alias{pooled_vc}
\title{Compute pooled variance-covariance matrix}
\usage{
pooled_vc(x, cl, prior = rep(1/length(unique(cl)), length(unique(cl))))
}
\arguments{
\item{x}{multivariate data set, matrix.}

\item{cl}{class variable}

\item{prior}{prior probability for each class, must sum to 1, default all equal}
}
\value{
matrix
}
\description{
This function computes the group variance-covariance
matrices, and produces a weighted average. It is useful
for examining the linear discriminant analysis model.
}
\examples{
data(clusters)
pooled_vc(clusters[,1:5], clusters$cl)
}
