% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdm.R
\name{priors.spec}
\alias{priors.spec}
\title{Specify the priors. Without inputs, defaults will be used.}
\usage{
priors.spec(m0 = 0, CS0 = 3, n0 = 0.001, d0 = 0.001)
}
\arguments{
\item{m0}{the value of the prior mean at time \code{t=0}, scalar (assumed to be the same
for all nodes). The default is zero.}

\item{CS0}{controls the scaling of the prior variance matrix \code{C*_{0}} at time 
\code{t=0}. The default is 3, giving a non-informative prior for \code{C*_{0}, 3 x (p x p)}
identity matrix. \code{p} is the number of thetas.}

\item{n0}{prior hyperparameter of precision \code{phi ~ G(n_{0}/2; d_{0}/2)}. The default
is a non-informative prior, with \code{n0 = d0 = 0.001}. \code{n0} has to be higher than 0.}

\item{d0}{prior hyperparameter of precision \code{phi ~ G(n_{0}/2; d_{0}/2)}. The default
is a non-informative prior, with \code{n0 = d0 = 0.001}.}
}
\value{
\code{priors} a list with the prior hyperparameters. Relevant to \code{\link{dlm.lpl},
 \link{exhaustive.search}, \link{node}, \link{subject}}.
}
\description{
Specify the priors. Without inputs, defaults will be used.
}
\details{
At time \code{t=0}, \code{(theta_{0} | D_{0}, phi) ~ N(m_{0},C*_{0} x phi^{-1})},
 where \code{D_{0}} denotes the set of initial information.
}
\references{
West, M. & Harrison, J., 1997. Bayesian Forecasting and Dynamic Models. Springer New York.
}
