% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSOpt.R
\name{MSOpt}
\alias{MSOpt}
\title{Experimental setup}
\usage{
MSOpt(facts, units, levels, etas, criteria, model)
}
\arguments{
\item{facts}{A list of vectors representing the distribution of factors
across strata. Each item in the list represents a stratum and the first item
is the highest stratum of the multi-stratum structure of the experiment.
Within the vectors, experimental factors are indicated by progressive integer
from \eqn{1} (the first factor of the highest stratum) to the total number of
experimental factors (the last factor of the lowest stratum). Blocking
factors are denoted by empty vectors.}

\item{units}{A list whose \eqn{i}-th element is the number of experimental
units within each unit at the previous stratum \eqn{i-1}.
The first item in the list, \eqn{n_1}{n1}, represents the number of experimental
units in the stratum \eqn{0}, defined as the entire experiment (so that
\eqn{n_0 = 1}{n0 = 1}).}

\item{levels}{A vector containing the number of available levels for each
experimental factor in \code{facts} (blocking factors are excluded). If all
experimental factors share the number of levels one integer is sufficient.}

\item{etas}{A list specifying the ratios of error variance between subsequent
strata. It follows that \code{length(etas)} must be equal to
\code{length(facts)-1}.}

\item{criteria}{A list specifying the criteria to be optimized. It can
contain any combination of:
\itemize{
  \item{``I" : I-optimality}
  \item{``Id" : Id-optimality}
  \item{``D" : D-optimality}
  \item{``A" : Ds-optimality}
  \item{``Ds" : A-optimality}
  \item{``As" : As-optimality}
}
More detailed information on the available criteria is given under
\strong{Details}.}

\item{model}{A string which indicates the type of model, among ``main",
``interaction" and ``quadratic".}
}
\value{
\code{MSOpt} returns a list containing the following components:
\itemize{
\item{\code{facts}: The argument \code{facts}.}
\item{\code{nfacts}: An integer. The number of experimental factors (blocking factors are excluded from the count).}
\item{\code{nstrat}: An integer. The number of strata.}
\item{\code{units}: The argument \code{units}.}
\item{\code{runs}: An integer. The total number of runs.}
\item{\code{etas}: The argument \code{etas}.}
\item{\code{avlev}: A list showing the available levels for each experimental factor.
The design space for each factor is [-1, 1].}
\item{\code{levs}: A vector showing the number of available levels for each experimental factor.}
\item{\code{Vinv}: The inverse of the variance-covariance matrix of the responses.}
\item{\code{model}: The argument \code{model}.}
\item{\code{crit}: The argument \code{criteria}.}
\item{\code{ncrit}: An integer. The number of criteria considered.}
\item{\code{M}: The moment matrix. Only with I-optimality criteria.}
\item{\code{M0}: The moment matrix. Only with Id-optimality criteria.}
\item{\code{W}: The diagonal matrix of weights. Only with As-optimality criteria.}
}
}
\description{
The \code{MSOpt} function allows the user to define the
structure of the experiment, the set of optimization criteria and the a priori
model to be considered. The output is a list containing all information about
the settings of the experiment. According to the declared criteria, the list
also contains the basic matrices for their implementation, such as information
matrix, matrix of moments and matrix of weights. The returned list
is argument of the \code{\link[multiDoE]{Score}} and \code{\link[multiDoE]{MSSearch}}
functions of the \code{multiDoE} package.
}
\details{
A little notation is introduced to show the criteria that can be
used in the multi-objective approach of the \code{multiDoE} package. \cr

For an experiment with \eqn{N} runs and \eqn{s} strata, with stratum \eqn{i}
having \eqn{n_i}{ni} units within each unit at stratum \eqn{i-1} and
stratum 0 being defined as the entire experiment (\eqn{n_0 = 1}{n0 = 1}), the
general form of the model can be written as:

\deqn{y = X\beta + \sum\limits_{i = 1}^{s} Z_i\varepsilon_i}{y = X\beta +
\sum{i=1}^{s} Zi \epsiloni,}

where
\eqn{y} is an \eqn{N}-dimensional vector of responses (\eqn{N = \prod_{j = 1}^{s}n_j}{N = \prod{j = 1}^{s}nj}),
\eqn{X} is an \eqn{N} by \eqn{p} model matrix,
\eqn{\beta} is a \eqn{p}-dimensional vector containing the \eqn{p} fixed model parameters,
\eqn{Z_i}{Zi} is an \eqn{N} by \eqn{b_i}{bi} indicator matrix of \eqn{0} and
    \eqn{1} for the units in stratum \eqn{i} (i.e. the (\eqn{k,l})th element
    of \eqn{Z_i}{Zi} is \eqn{1} if the \eqn{k}th run belongs to the \eqn{l}th
    block in stratum \eqn{i} and \eqn{0} otherwise) and
\eqn{b_i = \prod_{j = 1}^{i}n_j}{bi = \prod{j = 1}^{i}nj}.
Finally, the vector \eqn{\varepsilon_i \sim N(0,\sigma_i^2I_{b_i})}{%
\epsiloni ~ N(0, \sigmai^{2} I_{bi})} is a \eqn{b_i}{bi}-dimensional vector
containing the random effects, which are all uncorrelated. The variance
components \eqn{\sigma^{2}_{i} (i = 1, \dots, s)}{\sigmai^{2}
(i = 1, \dots, s)} have to be estimated and this is usually done using
the REML (REstricted Maximum Likelihood) method.

The best linear unbiased estimator for the parameter vector \eqn{\beta} is
the generalized least square estimator:
\deqn{ \hat{\beta}_{GLS} = (X'V^{-1}X)^{-1}X'V^{-1}y}{%
       hat{\beta}_{GLS} = (X' V^{-1} X)^{-1} X' V^{-1} y.}

This estimator has variance-covariance matrix:
\deqn{Var(\hat{\beta}_{GLS}) = \sigma^{2}(X'V^{-1}X)^{-1}}{%
      Var(hat{\beta}_{GLS}) = \sigma^{2} (X' V^{-1} X)^{-1}, }

where
\eqn{V = \sum\limits_{i = 1}^{s}\eta_i Z_i'Zi}{V = \sum{i = 1}^{s} (\etai Zi'Zi)},
\eqn{\eta_i = \frac{\sigma_i^{2}}{\sigma^{2}}}{\etai = \sigmai^{2} / \sigma^{2}} and
\eqn{\sigma^{2} = \sigma^{2}_{s}}{\sigma^{2} = \sigmas^{2}}.

Let \eqn{M = (X' V^{-1} X)} be the information matrix about \eqn{\hat{\beta}}{%
hat{\beta}} and let \eqn{\eta} be the vector of the variance components.

\itemize{
\item{ \strong{D-optimality.} It is based on minimizing the generalized
variance of the parameter estimates. This can be done either by minimizing the
determinant of the variance-covariance matrix of the factor effects' estimates
or by maximizing the determinant of \eqn{M}. \cr
The objective function to be minimized is:
\deqn{f_{D}(d; \eta) = \left(\frac{1}{\det(M)}\right)^{1/p}}{%
      f_D(d; \eta) = (1 / det(M))^{1/p},}
where \eqn{d} is the design with information matrix \eqn{M} and \eqn{p} is the
number of model parameters.}

\item{ \strong{A-optimality.} This criterion is based on
minimizing the average variance of the estimates of the regression coefficients.
The sum of the variances of the parameter estimates (elements of
\eqn{\hat{\beta}}{hat{\beta}}) is taken as a measure, which is equivalent to
considering the trace of \eqn{M^{-1}}. \cr
The objective function to be minimized is:
\deqn{f_{A}(d; \eta) = trace(M^{-1})/p}{f_A(d; \eta) = trace(M^{-1})/p,}
where \eqn{d} is the design with information matrix \eqn{M} and \eqn{p} is the
number of model parameters.}

\item{ \strong{I-optimality.} It seeks to minimize the average
prediction variance. \cr
The objective function to be minimized is:
\deqn{f_{I}(d; \eta) = \frac{\int_{\chi} f'(x)(M)^{-1}f(x)\,dx }{\int_{\chi} \,dx}}{%
      f_I(d; \eta) = (integral_{\chi} f'(x)(M)^{-1}f(x) dx) / (integral_{\chi} dx), }
where \eqn{d} is the design with information matrix \eqn{M} and \eqn{\chi}
represents the design region. \cr
It can be proved that when there are \eqn{k} treatment factors each with two
levels, so that the experimental region is of the form \eqn{[-1, +1]^{k}},
the objective function can also be written as:
\deqn{f_{I}(d; \eta) = trace \left[(M)^{-1} B\right]}{%
      f_I(d; \eta) = trace[(M)^{-1} B],}
where \eqn{d} is the design with information matrix \eqn{M} and
\eqn{B = 2^{-k} \int_{\chi}f'(x)f(x) \,dx }{%
     B = 2^{-k} (integral_{\chi} f'(x)f(x) dx)} is the moments matrix.
To know the implemented expression for calculating the moments matrix for a
cuboidal design region see section 2.3 of Sambo, Borrotti, Mylona, and Gilmour
(2016).}

\item{ \strong{Ds-optimality.} Its aim is to minimize the generalized
variance of the parameter estimates by excluding the intercept from the set
of parameters of interest. Let \eqn{\beta_i}{\betai} be the model parameter
vector of dimension (\eqn{p_i - 1}{pi-1}) to be estimated in stratum \eqn{i}.
Let \eqn{X_i}{Xi} be the associated model matrix \eqn{m_i}{mi} by \eqn{(p_i-1)}{%
(pi-1)}, where \eqn{m_i}{mi} is the number of units in stratum \eqn{i}.
The partition of interest of the matrix of variances and covariances of
\eqn{\hat{\beta}_i}{hat{\betai}} is
\deqn{(M_i^{-1})_{22} = [X'_i (I - \frac{1}{m_i} 11^{'})X_i]^{-1}}{%
(Mi^{-1})_{22} = [Xi' (I - (1 / mi) 11') Xi]^{-1}.} \cr
The objective function to be minimized is:
\deqn{f_{D_s}(d; \eta) = (|(M_i^{-1})_{22}|)^{1/(p_i-1)}}{%
f_Ds(d; \eta) = (|(Mi^{-1})_{22}|)^{1/(pi-1)}.}}


\item{\strong{As-optimality.} This criterion is based on minimizing
the average variance of the estimates of the regression coefficients by excluding
the intercept from the set of parameters of interest. \cr
With reference to the notation introduced for the previous criterion, the
objective function to be minimized is:
\deqn{f_{A_s}(d; \eta) = trace(W_i(M_i^{-1})_{22})}{%
      f_As(d; \eta) = trace(Wi (Mi^{-1})_{22}),}
where \eqn{W_i}{Wi} is a diagonal matrix of weights, with the weights scaled
so that the trace of \eqn{W_i}{Wi} is equal to 1. Specifically the implemented
matrix assigns to each main effect and each interaction effect an absolute
weight equal to 1, while to the quadratic effects it assigns an absolute weight
equal to 1/4.}

\item{ \strong{Id-optimality.} It seeks to minimize the average
prediction variance by excluding the intercept from the set of parameters of
interest. \cr
The objective function to be minimized is the same as the
I-optimality criterion where the first row and columns of the \eqn{B}
matrix (see the \strong{Id-optimality} criterion) are deleted.}
}
}
\examples{
## This example uses MSOpt to setup a split-plot design with
## 1 whole-plot factor and 4 subplot factors, which in the \code{facts}
## element appear numbered from 2 to 5.
## The experiment must be structured as follows: 6 whole plots and 5 subplots
## per whole plot, for a total of 30 runs.
## Each experimental factor has 3 different levels.

## To check the number of digits to be printed.
backup_options <- options()
options(digits = 10)

facts <- list(1, 2:5)
units <- list(6, 5)
levels <- 3
etas <- list(1)
criteria <- c('I', 'D', 'A')
model <- "quadratic"

msopt <- MSOpt(facts, units, levels, etas, criteria, model)

options(backup_options)

}
\references{
M. Borrotti and F. Sambo and K. Mylona and S. Gilmour. A multi-objective
coordinate-exchange two-phase local search algorithm for multi-stratum
experiments. Statistics & Computing, 2017.

S. G. Gilmour, J. M. Pardo, L. A. Trinca, K. Niranjan, D.S. Mottram. A
split-plot response surface design for improving aroma retention in freeze
dried coffee. In: Proceedings of the 6th. European conference on Food-Industry
Statist, 2000.
}
