% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_sel.R
\name{adjust_sel}
\alias{adjust_sel}
\title{Adust for selection bias.}
\usage{
adjust_sel(
  data_observed,
  data_validation = NULL,
  s_model_coefs = NULL,
  level = 0.95
)
}
\arguments{
\item{data_observed}{Object of class \code{data_observed} corresponding to the
data to perform bias analysis on.}

\item{data_validation}{Object of class \code{data_validation} corresponding to
the validation data used to adjust for bias in the observed data. Here, the
validation data should have data for the same variables as in the observed
data, plus data for the selection indicator representing whether the
observation was selected in \code{data_observed}.}

\item{s_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(S=1)) = &beta;<sub>0</sub> + &beta;<sub>1</sub>X + &beta;<sub>2</sub>Y, }}{\eqn{logit(P(S=1)) = \beta_0 + \beta_1 X + \beta_2 Y, }}
where \emph{S} represents binary selection, \emph{X} is the exposure,
and \emph{Y} is the outcome. The number of parameters is therefore 3.}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
effect of the exposure on the outcome and the second item is the
confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_sel} returns the exposure-outcome odds ratio and confidence
interval, adjusted for selection bias.
}
\details{
Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
df_observed <- data_observed(
  data = df_sel,
  exposure = "X",
  outcome = "Y",
  confounders = "C1"
)

# Using validation data -----------------------------------------------------
df_validation <- data_validation(
  data = df_sel_source,
  true_exposure = "X",
  true_outcome = "Y",
  confounders = "C1",
  selection = "S"
)

adjust_sel(
  data_observed = df_observed,
  data_validation = df_validation
)

# Using s_model_coefs -------------------------------------------------------
adjust_sel(
  data_observed = df_observed,
  s_model_coefs = c(0, 0.9, 0.9)
)

}
