% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sopls.R
\name{sopls}
\alias{sopls}
\title{Sequential and Orthogonalized PLS (SO-PLS)}
\usage{
sopls(
  formula,
  ncomp,
  max_comps = min(sum(ncomp), 20),
  data,
  subset,
  na.action,
  scale = FALSE,
  validation = c("none", "CV", "LOO"),
  sequential = FALSE,
  segments = 10,
  sel.comp = "opt",
  progress = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictor block names separated by + signs.}

\item{ncomp}{Numeric vector of components per block or scalar of overall maximum components.}

\item{max_comps}{Maximum total number of components from all blocks combined (<= sum(ncomp)).}

\item{data}{The data set to analyse.}

\item{subset}{Expression for subsetting the data before modelling.}

\item{na.action}{How to handle NAs (no action implemented).}

\item{scale}{Logical indicating if variables should be scaled.}

\item{validation}{Optional cross-validation strategy "CV" or "LOO".}

\item{sequential}{Logical indicating if optimal components are chosen sequentially or globally (default=FALSE).}

\item{segments}{Optional number of segments or list of segments for cross-validation. (See \code{[pls::cvsegments()]}).}

\item{sel.comp}{Character indicating if sequential optimal number of components should be chosen as minimum RMSECV ('opt', default) or by Chi-square test ('chi').}

\item{progress}{Logical indicating if a progress bar should be displayed while cross-validating.}

\item{...}{Additional arguments to underlying methods.}
}
\value{
An \code{sopls, mvr} object with scores, loadings, etc.
associated with printing (\code{\link{sopls_results}}) and plotting methods (\code{\link{sopls_plots}}).
}
\description{
Function for computing standard SO-PLS based on the interface of the \code{pls} package.
}
\details{
SO-PLS is a method which handles two or more input blocks by sequentially performing
PLS on blocks against a response and orthogonalising the remaining blocks on the extracted components.
Component number optimisation can either be done globally (best combination across blocks) or sequentially
(determine for one block, move to next, etc.).
}
\examples{
data(potato)
so <- sopls(Sensory ~ Chemical + Compression, data=potato, ncomp=c(10,10), 
            max_comps=10, validation="CV", segments=10)
summary(so)

# Scatter plot matrix with two first components from Chemical block
# and 1 component from the Compression block.
scoreplot(so, comps=list(1:2,1), ncomp=2, block=2)

# Result functions and more plots for SO-PLS 
# are found in ?sopls_results and ?sopls_plots.
}
\references{
Jørgensen K, Mevik BH, Næs T. Combining designed experiments with several blocks of spectroscopic data. Chemometr Intell Lab Syst. 2007;88(2): 154–166.
}
\seealso{
SO-PLS result functions, \code{\link{sopls_results}}, SO-PLS plotting functions, \code{\link{sopls_plots}}, SO-PLS Måge plot, \code{\link{maage}}, and SO-PLS path-modelling, \code{\link{SO_TDI}}.
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
