% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_miscellanea.R
\name{mc_count_clauses}
\alias{mc_count_clauses}
\title{Count clause units in a multicastR table}
\usage{
mc_count_clauses(text)
}
\arguments{
\item{text}{A \code{\link[data.table]{data.table}} in multicastR format,
containing minimally a \code{corpus} column with the names of the corpora
and a \code{graid} column with GRAID annotation values.}
}
\value{
A \code{\link[data.table]{data.table}} with the number of valid
  clause units in each corpus, the total number of clause units, the number
  of non-analyzed clause units ("NC"), and the percentage the later make up
  of the total.
}
\description{
Counts number of clause units (bounded by the \code{<##>}, \code{<#>}, or
\code{<\%>} annotation symbols) in a multicastR table.
}
\examples{
# count clause units in the most recent version
# of the Multi-CAST data, by corpus
n <- mc_count_clauses(multicast())

# number of clauses units in the whole collection
sum(n$nClauses)

}
\seealso{
\code{\link{multicast}}
}
\keyword{internal}
