% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/universe_cs.R
\name{universe_cs}
\alias{universe_cs}
\title{universe_cs}
\usage{
universe_cs(
  cs1,
  cs2,
  data,
  subj,
  group = NULL,
  include_bayes = TRUE,
  include_mixed = FALSE,
  phase = "acquisition",
  dv = "scr",
  print_output = TRUE,
  exclusion = "full data",
  cut_off = "full data",
  correction = FALSE,
  meta.effect = "d_to_eta2"
)
}
\arguments{
\item{cs1}{The column name(s) of the conditioned responses for the first conditioned stimulus}

\item{cs2}{The column name(s) of the conditioned responses for the second conditioned stimulus}

\item{data}{A data frame containing all the relevant columns for the analyses}

\item{subj}{The name of the column including the participant numbers. Unique numbers are expected}

\item{group}{the name of the group, if included, default to \code{NULL}}

\item{include_bayes}{Whether the Bayesian analyses should be run. Default to \code{TRUE}}

\item{include_mixed}{Whether the mixed model results should be run. Default to \code{FALSE}}

\item{phase}{The conditioned phase that the analyses refer to. Accepted values are  \code{acquisition}, \code{acq}, \code{extinction}, or \code{ext}}

\item{dv}{name of the measured conditioned response. Default to \code{"SCR"}}

\item{print_output}{Whether to print the output or not. Default set to \code{TRUE}}

\item{exclusion}{Name of the data reduction procedure used. Default to \code{full data}}

\item{cut_off}{cut off score}

\item{correction}{whether the Greenhouse-Geisser correction should be applied or not. Default to \code{FALSE}}

\item{meta.effect}{How the meta-analytic effect should be computed.}
}
\value{
A tibble with the following column names:
x: the name of the independent variable (e.g., cs)
y: the name of the dependent variable as this defined in the \code{dv} argument
exclusion: see \code{exclusion} argument
model: the model that was run (e.g., t-test)
controls: ignore this column for this test
method: the method used
p.value: the reported p-value
effect.size: the reported effect size
estimate: the estimate of the test run
statistic: the value of the test
conf.low: the lower confidence interval for the estimate
conf.high: the higher confidence interval for the estimate
framework: were the data analysed within a NHST or Bayesian framework?
data_used: a list with the data used for the specific test
}
\description{
Basic function for running a multiverse analysis for a single data set
}
\details{
In case of higher order interaction, only the highest order
effect is shown.

In case the CSs include only 1 observation per participant, or of unequal numbers of CS trials, the
function will return the warning ""Skipping ANOVA due to the number of trials for the cs1 and/or
cs2."".
}
\examples{
# Load data and define argument to be fed in universe_cs
data("example_data", package = "multifear")
example_data <- example_data[1:10, ]
cs1 <- paste0("CSP", 1:10)
cs2 <- paste0("CSM", 1:10)
subj = "id"
multifear::universe_cs(cs1, cs2, subj = subj, data = example_data, include_bayes = FALSE)
}
