% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmedmlm.R
\name{modmed.mlm}
\alias{modmed.mlm}
\title{Model definition and estimation function for two-level (moderated) mediation}
\usage{
modmed.mlm(
  data,
  L2ID,
  X,
  Y,
  M,
  moderator = NULL,
  mod.a = FALSE,
  mod.b = FALSE,
  mod.cprime = FALSE,
  covars.m = NULL,
  covars.y = NULL,
  random.a = FALSE,
  random.b = FALSE,
  random.cprime = FALSE,
  random.mod.a = FALSE,
  random.mod.b = FALSE,
  random.mod.cprime = FALSE,
  random.mod.m = FALSE,
  random.mod.y = FALSE,
  random.covars.m = NULL,
  random.covars.y = NULL,
  method = "REML",
  control = lmeControl(maxIter = 10000, msMaxIter = 10000, niterEM = 10000, msMaxEval =
    10000, tolerance = 1e-06),
  returndata = FALSE,
  datmfun = NULL,
  data.stacked = NULL,
  ...
)
}
\arguments{
\item{data}{Data frame in long format.}

\item{L2ID}{(Character) Name of column that contains grouping variable in \code{data} (e.g., \code{"SubjectID"}).}

\item{X}{(Character) Name of column that contains the X independent variable in \code{data}.}

\item{Y}{(Character) Name of column that contains the Y dependent variable in \code{data}.}

\item{M}{(Character) Name of column that contains the M mediating variable in \code{data}.}

\item{moderator}{Optional Character that contains name of column that contains the moderator variable in \code{data}}

\item{mod.a}{(Logical) Add moderator to 'a' path (i.e., SmX:W, where W is the moderator)?}

\item{mod.b}{(Logical) Add moderator to 'b' path (i.e., SyM:W, where W is the moderator)?}

\item{mod.cprime}{(Logical) Add moderator to 'c' path (i.e., SyX:W, where W is the moderator)}

\item{covars.m}{(Character vector) Optional covariates to include in the model for M.}

\item{covars.y}{(Character vector) Optional covariates to include in the model for Y.}

\item{random.a}{(Logical) Add random slope for 'a' path (i.e,. SmX)?}

\item{random.b}{(Logical) Add random slope for 'b' path (i.e., SyM)?}

\item{random.cprime}{(Logical) Add random slope for 'cprime' direct effect path (i.e., SyX)?}

\item{random.mod.a}{(Logical) Add random slope for 'a' path moderator?}

\item{random.mod.b}{(Logical) Add random slope for 'b' path moderator?}

\item{random.mod.cprime}{(Logical) Add random slope for 'c' path moderator?}

\item{random.mod.m}{(Logical) Add random slope for effect of moderator on M?}

\item{random.mod.y}{(Logical) Add random slope for effect of moderator on Y?}

\item{random.covars.m}{(Logical vector) Add random slopes for covariates on M?}

\item{random.covars.y}{(Logical vector) Add random slopes for covariates on Y?}

\item{method}{Argument passed to \code{\link[nlme]{lme}} to control estimation method.}

\item{control}{Argument passed to \code{\link[nlme]{lme}} that controls other estimation options.}

\item{returndata}{(Logical) Whether to save restructured data in its own slot. Note: nlme may do this automatically. Defaults to \code{FALSE}.}

\item{datmfun}{(experimental) A function that will do additional data manipulation on the restacked dataset. The function ought to take
the restacked dataset (e.g., done using \code{\link{stack_bpg}}) and return a dataset that can be analyzed using \code{\link{modmed.mlm}} Could be used for
some kind of additional centering strategy after data are restacked (and after bootstrapped) or some other missing data handling strategy.
Either suggestion requires further study.#'}

\item{data.stacked}{(experimental) Currently used internally by bootresid.modmed.mlm to feed already stacked data to the function.}

\item{...}{Pass any additional options down to \code{link[nlme]{lme}}. Added to handle missing values. e.g., \code{na.action = na.omit}.}
}
\value{
A list with the following elements:
\itemize{
 \item{\code{model} The fitted model using \code{\link[nlme]{lme}}. Use as you would a fitted model from that package.}
 \item{\code{args} Arguments used to call the function. Useful for later automating extraction of the indirect
   effect or other quantities.}
 \item{\code{conv} Whether estimation appeared to converge.}
 \item{\code{data} If you asked for the restructured dataset to be returned, it shall be here.}
}
}
\description{
Model definition and estimation function for two-level (moderated) mediation
}
\details{
Implements custom function to do 1-1-1 multilevel mediation model following Bauer, Preacher, & Gil (2006).
  The basic procedure involves restructuring the data (\code{\link{stack_bpg}}) and then estimating the model using \code{\link[nlme]{lme}}.
  The model assumes heteroscedasticity  since the mediator and outcome variable may have different error variances.
  The function also supports covariates as predictors of the mediator and/or outcome, as well as moderated mediation.
  Currently a single moderator variable is supported and it may moderate any/all paths of the model. However, the
  the moderator is assumed continuous. While it may be possible to include moderators that are categorical, it is
  not currently automated (i.e., the user will need to manually code the categorical variable as numeric).

  For more information for variable labels and how these will correspond to the output coefficients, see the documentation for \code{\link{stack_bpg}},
  as those docs contain a description of all of the variables.
}
\examples{

\donttest{
# Example data for 1-1-1 w/o moderation
data(BPG06dat)

# Fit model
fit<-modmed.mlm(BPG06dat,"id", "x", "y", "m",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE)

extract.modmed.mlm(fit)
extract.modmed.mlm(fit, type="indirect")
extract.modmed.mlm(fit, type="a")
extract.modmed.mlm(fit, type="b")
extract.modmed.mlm(fit, type="covab")

# Vector of parameter estimates, including indirect effect
#fit$pars

# The saved, fitted model following Bauer, Preacher, & Gil (2006)
summary(fit$model)
}

\donttest{
# Fit model with moderation
data(simdat)

# moderation for a path
fitmoda<-modmed.mlm(simdat,"L2id", "X", "Y", "M",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
  moderator = "mod", mod.a=TRUE)

# moderation for b path
fitmodb<-modmed.mlm(simdat,"L2id", "X", "Y", "M",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
  moderator = "mod", mod.b=TRUE)

# moderation for both a and b paths
fitmodab<-modmed.mlm(simdat,"L2id", "X", "Y", "M",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
  moderator = "mod", mod.a=TRUE, mod.b=TRUE)

# moderation for both a and b paths and random effect for interaction a
fitmodab2<-modmed.mlm(simdat,"L2id", "X", "Y", "M",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
  moderator = "mod", mod.a=TRUE, mod.b=TRUE,
  random.mod.a = TRUE, random.mod.m = TRUE)

# moderation for both a and b paths and random effect for interaction b
fitmodab3<-modmed.mlm(simdat,"L2id", "X", "Y", "M",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
  moderator = "mod", mod.a=TRUE, mod.b=TRUE,
  random.mod.b = TRUE, random.mod.y = TRUE)

# moderation for both a and b paths and random effect for both interactions
fitmodab4<-modmed.mlm(simdat,"L2id", "X", "Y", "M",
  random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
  moderator = "mod", mod.a=TRUE, mod.b=TRUE,
  random.mod.a = TRUE, random.mod.b = TRUE,
  random.mod.m = TRUE, random.mod.y = TRUE)

# compare models?
# Apparently anova() is not supported as it's looking for fixed.formula,
# as it's not in the current environment
# AIC works though
AIC(fitmodab$model)
AIC(fitmodab2$model)
AIC(fitmodab3$model)
AIC(fitmodab4$model) # AIC here is best. Great simulated data we have here

extract.modmed.mlm(fitmodab4, "indirect")
extract.modmed.mlm(fitmodab4, "indirect", modval1=0) # should match above
extract.modmed.mlm(fitmodab4, "indirect", modval1=1)
extract.modmed.mlm(fitmodab4, "indirect.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab4, "indirect", modval1=0)-
  extract.modmed.mlm(fitmodab4, "indirect", modval1=1) # should match prev line

extract.modmed.mlm(fitmodab4, "a")
extract.modmed.mlm(fitmodab4, "a", modval1=0) # should match above
extract.modmed.mlm(fitmodab4, "a", modval1=1)
extract.modmed.mlm(fitmodab4, "a.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab4, "a", modval1=0)-
  extract.modmed.mlm(fitmodab4, "a", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab4, "b")
extract.modmed.mlm(fitmodab4, "b", modval1=0) # should match above
extract.modmed.mlm(fitmodab4, "b", modval1=1)
extract.modmed.mlm(fitmodab4, "b.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab4, "b", modval1=0)-
  extract.modmed.mlm(fitmodab4, "b", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab3, "indirect")
extract.modmed.mlm(fitmodab3, "indirect", modval1=0) # should match above
extract.modmed.mlm(fitmodab3, "indirect", modval1=1)
extract.modmed.mlm(fitmodab3, "indirect.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab3, "indirect", modval1=0)-
  extract.modmed.mlm(fitmodab3, "indirect", modval1=1) # should match prev line

extract.modmed.mlm(fitmodab3, "a")
extract.modmed.mlm(fitmodab3, "a", modval1=0) # should match above
extract.modmed.mlm(fitmodab3, "a", modval1=1)
extract.modmed.mlm(fitmodab3, "a.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab3, "a", modval1=0)-
  extract.modmed.mlm(fitmodab3, "a", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab3, "b")
extract.modmed.mlm(fitmodab3, "b", modval1=0) # should match above
extract.modmed.mlm(fitmodab3, "b", modval1=1)
extract.modmed.mlm(fitmodab3, "b.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab3, "b", modval1=0)-
  extract.modmed.mlm(fitmodab3, "b", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab2, "indirect")
extract.modmed.mlm(fitmodab2, "indirect", modval1=0) # should match above
extract.modmed.mlm(fitmodab2, "indirect", modval1=1)
extract.modmed.mlm(fitmodab2, "indirect.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab2, "indirect", modval1=0)-
  extract.modmed.mlm(fitmodab2, "indirect", modval1=1) # should match prev line

extract.modmed.mlm(fitmodab2, "a")
extract.modmed.mlm(fitmodab2, "a", modval1=0) # should match above
extract.modmed.mlm(fitmodab2, "a", modval1=1)
extract.modmed.mlm(fitmodab2, "a.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab2, "a", modval1=0)-
  extract.modmed.mlm(fitmodab2, "a", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab2, "b")
extract.modmed.mlm(fitmodab2, "b", modval1=0) # should match above
extract.modmed.mlm(fitmodab2, "b", modval1=1)
extract.modmed.mlm(fitmodab2, "b.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab2, "b", modval1=0)-
  extract.modmed.mlm(fitmodab2, "b", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab, "indirect")
extract.modmed.mlm(fitmodab, "indirect", modval1=0) # should match above
extract.modmed.mlm(fitmodab, "indirect", modval1=1)
extract.modmed.mlm(fitmodab, "indirect.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab, "indirect", modval1=0)-
  extract.modmed.mlm(fitmodab, "indirect", modval1=1) # should match prev line

extract.modmed.mlm(fitmodab, "a")
extract.modmed.mlm(fitmodab, "a", modval1=0) # should match above
extract.modmed.mlm(fitmodab, "a", modval1=1)
extract.modmed.mlm(fitmodab, "a.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab, "a", modval1=0)-
  extract.modmed.mlm(fitmodab, "a", modval1=1)  # should match prev line

extract.modmed.mlm(fitmodab, "b")
extract.modmed.mlm(fitmodab, "b", modval1=0) # should match above
extract.modmed.mlm(fitmodab, "b", modval1=1)
extract.modmed.mlm(fitmodab, "b.diff", modval1 = 0, modval2=1)
extract.modmed.mlm(fitmodab, "b", modval1=0)-
  extract.modmed.mlm(fitmodab, "b", modval1=1)  # should match prev line


# Example to not fail when using missing values
# Missing data handling is not that great as not all info is used, but is typical
# of default missing data handling strategies in MLM. See documentation for
# lme function in the nlme package for more options for na.action
dat.miss <- BPG06dat
dat.miss$m[c(1,2,3,4)]<-NA
dat.miss$y[c(5,6,7,8)]<-NA
fit<-modmed.mlm(dat.miss,"id", "x", "y", "m",
                random.a=TRUE, random.b=TRUE, random.cprime=TRUE,
                na.action = na.omit)
}
}
\references{
Bauer, D. J., Preacher, K. J., & Gil, K. M. (2006). Conceptualizing and testing random indirect effects and moderated mediation in multilevel models: New procedures and recommendations. Psychological Methods, 11(2), 142–163. \doi{10.1037/1082-989X.11.2.142}
}
