% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{parkinsons}
\alias{parkinsons}
\title{Mean off-time reduction in Parkison's disease}
\format{
A data frame with 15 rows and 7 variables:
\describe{
\item{studyn}{numeric study ID}
\item{trtn}{numeric treatment code (placebo = 1)}
\item{y}{mean off-time reduction}
\item{se}{standard error}
\item{n}{sample size}
\item{diff}{mean difference vs. treatment in reference arm}
\item{se_diff}{standard error of mean difference, see details}
}
}
\usage{
parkinsons
}
\description{
Data frame containing the mean off-time reduction in patients given dopamine
agonists as adjunct therapy in Parkinson's disease, from 7 trials comparing
four active drugs and placebo \insertCite{TSD2}{multinma}.
}
\details{
This dataset may be analysed using either an arm-based likelihood
using \code{y} and \code{se}, or a contrast-based likelihood using \code{diff} and
\code{se_diff} (or a combination of the two across different studies).

The contrast-based data is formatted as described in \code{\link[=set_agd_contrast]{set_agd_contrast()}}.
That is, for the chosen reference arm in each study, the mean difference
\code{diff} is set to \code{NA}, and \code{se_diff} is set to the standard error \code{se} of
the outcome on the reference arm.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
