%     The multitaper R package
%     Multitaper and spectral analysis package for R
%     Copyright (C) 2011 Karim Rahim 
%
%     Written by Karim Rahim and Wesley Burr.
%
%     This file is part of the multitaper package for R.
%
%     The multitaper package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The multitaper package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with multitaper.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     karim.rahim@gmail.com
%     112 Jeffery Hall, Queen's University, Kingston Ontario
%     Canada, K7L 3N6

\name{CETmonthly}
\alias{CETmonthly}
\title{Central England Temperature monthly time series}
\description{
  Central England Temperature monthly time series from the Hadley Center United Kingdom
  Meteorological Office, http://www.metoffice.gov.uk/hadobs/hadcet/.
  The data set represents monthly CET temperature values recorded to the nearest 
  tenth of a degree Celsius, and containing records for January 1659 through December 2011.
  This dataset was retrieved from the Met office at Hadley on Mar 10, 2012.
}
\usage{CETmonthly}
\format{ A data frame indicating the year, month and temperature 
     observed in Central England. This data-set contains 4237
     observations.
}
\references{
Parker DE, Horton EB (2005). Uncertainties in central England
temperature 1878-2003 and some improvements to the maximum and minimum
series. \emph{Int. J. Climatol}. 25: 1173--1188.
}
\keyword{datasets}
