% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show-pipelines.R
\name{show_code_filter}
\alias{show_code_filter}
\alias{show_code_preprocess}
\alias{show_code_model}
\alias{show_code_postprocess}
\alias{show_code_summary_stats}
\alias{show_code_corrs}
\alias{show_code_reliabilities}
\title{Show multiverse data code pipelines}
\usage{
show_code_filter(.grid, decision_num, copy = FALSE)

show_code_preprocess(.grid, decision_num, copy = FALSE)

show_code_model(.grid, decision_num, copy = FALSE)

show_code_postprocess(.grid, decision_num, copy = FALSE)

show_code_summary_stats(.grid, decision_num, copy = FALSE)

show_code_corrs(.grid, decision_num, copy = FALSE)

show_code_reliabilities(.grid, decision_num, copy = FALSE)
}
\arguments{
\item{.grid}{a full decision grid created by \code{\link{expand_decisions}}.}

\item{decision_num}{numeric. Indicates which 'universe' in the multiverse to
show underlying code.}

\item{copy}{logical. Whether to copy the pipeline code to the clipboard using
\code{\link[clipr]{write_clip}}. Defaults to \code{FALSE}.}
}
\value{
the code that generated results up to the specified point in an
analysis pipeline. The code is printed in the console and can be optionally
copied to the clipboard.
}
\description{
Each \code{show_code*} function should be self-explanatory - they indicate
where along the multiverse pipeline to extract code. The goal of these
functions is to create a window into each multiverse decision set
context/results and allow the user to inspect specific decisions straight from
the code that produced it.
}
\section{Functions}{
\itemize{
\item \code{show_code_preprocess()}: Show the code up to the preprocessing stage

\item \code{show_code_model()}: Show the code up to the modeling stage

\item \code{show_code_postprocess()}: Show the code up to the post-processing
stage

\item \code{show_code_summary_stats()}: Show the code for computing summary statistics

\item \code{show_code_corrs()}: Show the code for computing correlations

\item \code{show_code_reliabilities()}: Show the code for computing scale reliability

}}
