% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_gmm_gen.R
\name{mv_gmm_gen}
\alias{mv_gmm_gen}
\title{Generates data from a multi-view Gaussian mixture model}
\usage{
mv_gmm_gen(n, Pi, mu1, mu2, Sigma1, Sigma2)
}
\arguments{
\item{n}{number of observations}

\item{Pi}{K1 x K2 matrix where the (k, k')th entry contains the probability of an observation 
belonging to cluster k in View 1 and cluster k' in View 2}

\item{mu1}{p1 x K1 matrix where the columns contain the K1 cluster means in View 1}

\item{mu2}{p2 x K2 matrix where the columns contain the K2 cluster means in View 2}

\item{Sigma1}{p1 x p1 matrix containing the covariance matrix for View 1}

\item{Sigma2}{p2 x p2 matrix containing the covariance matrix for View 2}
}
\value{
A list containing the following components:
\item{data}{A list with two items: the view 1 n x p1 multivariate data set and 
the view 2 n x p2 multivariate data set }
\item{clusters}{A list with two items: the view 1 cluster memberships and 
the view 2 cluster memberships}
}
\description{
Generates data from a multi-view Gaussian mixture model with n observations 
and two views.
}
\examples{
# 25 draws from a two-view Gaussian mixture model where the clusters are independent
n <- 25
Pi <-  tcrossprod(c(0.5, 0.5), c(0.25, 0.25, 0.5))
mu1 <- cbind(c(2, 2), c(-2, 2))
mu2 <- cbind(c(0, 1), c(1, 0), c(-1, 0))
Sigma1 <- diag(rep(1, 2))
Sigma2 <- diag(rep(0.5, 2))

mv_gmm_gen(n, Pi, mu1, mu2, Sigma1, Sigma2)

}
\references{
Gao, L.L., Bien, J., Witten, D. (2019) Are Clusterings of Multiple Data Views Independent?
Biostatistics,  <DOI:10.1093/biostatistics/kxz001>

Gao, L.L., Witten, D., Bien, J. Testing for Association in Multi-View Network Data, preprint.
}
