% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mv_sbm_gen.R
\name{mv_sbm_gen}
\alias{mv_sbm_gen}
\title{Generates data from a stochastic block model for multiple network data views}
\usage{
mv_sbm_gen(n, Pi, theta1, theta2, sparse = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{Pi}{K1 x K2 matrix where the (k, k')th entry contains the probability of an observation 
belonging to community k in View 1 and community k' in View 2}

\item{theta1}{K1 x K1 matrix containing the between-community edge probabilities for View 1}

\item{theta2}{K2 x K2 matrix containing the between-community edge probabilities for View 2}

\item{sparse}{If true, return data views in sparseMatrix format}
}
\value{
A list containing the following components:
\item{data}{A list with two items: the n x n view 1 adjacency matrix and 
the n x n view 2 adjacency matrix}
\item{communities}{A list with two items: the view 1 community memberships and 
the view 2 community memberships}
}
\description{
Generates data from a stochastic block model for multiple network data views 
with n observations and two views.
}
\examples{
# 50 draws from a stochastic block model for two network data views 
# where the communities are dependent
n <- 50
Pi <- diag(c(0.5, 0.5))
theta1 <- rbind(c(0.5, 0.1), c(0.1, 0.5))
theta2 <- cbind(c(0.1, 0.5), c(0.5, 0.1))

mv_sbm_gen(n, Pi, theta1, theta2)

}
\references{
Gao, L.L., Witten, D., Bien, J. Testing for Association in Multi-View Network Data, preprint.
}
