welch <-
function(file, norm){
 comp = read.csv(file, sep=",", header=TRUE)
     comp.x = comp[,3:ncol(comp)]
     comp.x = cbind(comp[,2], comp[,1], comp.x)
     x <- comp.x
 x.x = x[,3:ncol(x)]
 rownames(x.x) = x[,2]
 k = matrix(x[,1], ncol=1)
  if (norm) {
 x.t <- t(x.x)
 x.s <- matrix(colSums(x.t), nrow=1)
 uni = matrix(rep(1,nrow(x.t)), ncol=1)
 area.uni<-uni%*%x.s
 x.areanorm<-x.t/area.uni
 x.areanorm = t(x.areanorm)
 x.n = cbind(k, x.areanorm)
  } else {
   x.n = cbind(k, x.x)
    }
 sorted = x.n[order(x.n[,1]),]	
 g = c()
 for (i in 1:nrow(sorted)) { 
  if (any(g == sorted[i,1])) {g=g} 
  else {g=matrix(c(g,sorted[i,1]), ncol=1)}
 }
 NoF=nrow(g)
 dirout.w = paste(getwd(), "/Univariate/Welch_Tests", sep="")
 dir.create(dirout.w)
 # Perform the Welch test for the effective combinations
 for (i in 1:NoF) {
  for (j in 1:NoF) { 
   if (i < j) {
    ni=paste("r.",i,".out",sep="")
    nj=paste("r.",j,".out",sep="")
    pwdi = paste(getwd(), "/Univariate/Groups/", ni, sep="")
    pwdj = paste(getwd(), "/Univariate/Groups/", nj, sep="")
    I=read.csv(pwdi, header=TRUE)
    J=read.csv(pwdj, header=TRUE)
    I = I[,-1]
    J = J[,-1]
    fin=ncol(sorted)-1
    we <- matrix(rep(NA, fin))
    for (q in 1:fin) {
    we[q,] <- t.test(I[,q],J[,q],var.equal=F,conf.level=.95,alternative="two.sided")$p.value
    }
    welch.ij=paste("WelchTest_",i,"vs",j, ".out", sep="")
    assign(welch.ij,we)
    write.csv(we, paste(dirout.w, welch.ij, sep="/"))
   }
  }
 }
}
