% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{buildScale}
\alias{buildScale}
\title{Build Scale}
\usage{
buildScale(root, scale = "minor", descending = FALSE, play = FALSE,
  pairs = FALSE, plot = FALSE, formatNotation = TRUE, ...)
}
\arguments{
\item{root}{String: Root note.  e.g. "C4"}

\item{scale}{String: Scale to build. Default = "minor"}

\item{descending}{Logical: If TRUE, return notes in descending order, otherwise in ascending
Default = FALSE}

\item{play}{Logical: If TRUE, play scale using \link{playNote}}

\item{pairs}{Logical: If TRUE and \code{play = TRUE}, play the root note along with each other note, in sequence}

\item{plot}{Logical: If TRUE, plot scale notes using \link{cplot.piano}}

\item{formatNotation}{Logical: If TRUE, format notes to include both flats and sharps
to avoid repeating the same letter. e.g. convert c("Gb4", "G4") to c("F#4", "G4")}

\item{...}{Additional arguments to be passed to \link{playNote} if \code{play = TRUE}}
}
\description{
Build scale
}
\details{
For convenience and consistency, all sharps and flats are denoted using flats
}
\examples{
buildScale("C4", "minor")
buildScale("B4", "minor", descending = TRUE, plot = TRUE)
\dontrun{
buildScale("B4", "minor", descending = TRUE, play = TRUE, plot TRUE)
}
}
\author{
Efstathios D. Gennatas
}
