% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/music_fn.R
\name{formatNotation}
\alias{formatNotation}
\title{Format Notation}
\usage{
formatNotation(notes)
}
\arguments{
\item{notes}{String, vector: Notes to format}
}
\description{
Converts the internal note representation which uses only flats, to the notation
commonly used to write scales and chords, where a mix of sharps and flats is used to avoid
repeating the same letter note. (e.g. \code{"G#5" "A5"}, instead of \code{"Ab5" "A5"})
e.g. convert the C4 Lydian from:
"C4"  "D4"  "E4"  "Gb4" "G4"  "A4"  "B4"  "C5"
to:
"C4"  "D4"  "E4"  "F#4" "G4"  "A4"  "B4"  "C5"
or convert the A4 major from:
"A4"  "B4"  "Db5" "D5"  "E5"  "Gb5" "Ab5" "A5"
to:
"A4"  "B4"  "C#5" "D5"  "E5"  "F#5" "G#5" "A5"
}
\examples{
formatNotation(c("Db4", "D4", "E4", "Gb4", "G4", "A4", "B4", "C5"))
}
\author{
Efstathios D. Gennatas
}
