% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_offset_ineqmat.R
\name{make_offset_ineqmat}
\alias{make_offset_ineqmat}
\title{Translate a hyperplane arrangement to a new center}
\usage{
make_offset_ineqmat(set, ineqmat = NULL, edo = 12)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set intended to be the
center of the new arrangement}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to "white," "black", "gray", "roth", "pastel," or "rosy",
giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}}, \code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}},
\code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, and \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}}. For other
arrangements, the desired inequality matrix can be entered directly.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
A matrix with the same shape as the ones that define the standard
arrangement of type \code{ineqmat}
}
\description{
By default, the various hyperplane arrangements of musicMCT treat
the "white" perfectly even scale as their center. (It is the point
where all the hyperplanes of the MCT, white, and black arrangements
intersect, and although the Rothenberg arrangements do not pass through
the scale by definition, it is still a center of symmetry for them.)
This function let you construct hyperplane arrangements that have been
shifted to treat any other set as their center. (Details on why you might
want this to come.)
}
\examples{
# When used for the sign vector with any central arrangement, the
# input `set` will have a sign vector of all 0s:
viennese_trichord <- c(0, 1, 6)
signvector(viennese_trichord, ineqmat=make_offset_ineqmat(viennese_trichord))

# Where does melodic minor lie in relation to major?
major <- c(0, 2, 4, 5, 7, 9, 11)
melmin <- c(0, 2, 3, 5, 7, 9, 11)
signvector(melmin, ineqmat=make_offset_ineqmat(major, ineqmat="white"))

}
\seealso{
\code{\link[=makeineqmat]{makeineqmat()}} for modal color theory arrangements; \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, and \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}} for other relevant arrangements.
}
