% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stash.R
\name{stash}
\alias{stash}
\title{Stash an object}
\usage{
stash(var, code, depends_on = NULL)
}
\arguments{
\item{var}{A variable to stash (as a string).}

\item{code}{The code to generate the object to be stashed.}

\item{depends_on}{A vector of other objects that this one depends on. Changes
to these objects will cause the re-running of the code, next time.}
}
\value{
Returns \code{NULL} (invisibly).
}
\description{
Stash an object after the first time is is created and re-load it the next
time. If the code that generates the object is changed or any of its
dependencies change, the code is re-evaluated and the new object is stashed.
}
\examples{
\donttest{
# A value that is used to create `rnd_vals`.
x <<- 1e6  # The `<<-` is not normally required, just for this example.

# Stash the results of the comuption of `rnd_vals`.
stash("rnd_vals", depends_on = "x", {
    # Some long running computation.
    rnd_vals <- rnorm(x)
})
}

}
