% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_here.R
\name{use_here}
\alias{use_here}
\title{Use the 'here' package when writing stashes to file}
\usage{
use_here(silent = FALSE)
}
\arguments{
\item{silent}{A logical to silence the message from the function. (default
\code{FALSE})}
}
\value{
Returns \code{NULL} (invisibly).
}
\description{
Sets an option that tells \code{stash()} to write the stashed objects to a
path created using the \code{here::here()} function from the
\href{https://here.r-lib.org}{'here'} package: "The 'here' package creates
paths relative to the top-level directory." It is particularly useful when
using an RStudio project.
}
\details{
Add \code{mustashe::use_here(silent = TRUE)} to your '.Rprofile' or
\code{setup} code block in an R Markdown to set this feature automatically in
the future.
}
\examples{
use_here()
}
