% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{revCompl}
\alias{revCompl}
\title{Compute Reverse Complement sequences.}
\usage{
revCompl(DNAseq, rev = TRUE, compl = TRUE)
}
\arguments{
\item{DNAseq}{character vector of DNA sequences}

\item{rev}{logical, shall the reverse sequence be computed}

\item{compl}{logical, shall the complementary sequence be computed}
}
\value{
a character vector including transformed DNA sequences
}
\description{
Transform a DNA sequence into its reverse-complement sequence.
ALternatively, only the reverse sequence (or only the complement) can be returned.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
A <- c("TAACCG", "CTCGA", "CNNA")
mutSignatures::revCompl(A)

}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
