% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvTQMC.R
\name{mvTProbQuasiMonteCarlo}
\alias{mvTProbQuasiMonteCarlo}
\title{Multivariate t distribution function}
\usage{
mvTProbQuasiMonteCarlo(p, upperBound, cov, nu, genVec)
}
\arguments{
\item{p}{Number of samples used for quasi-Monte Carlo estimation. Must be a prime number.}

\item{upperBound}{Vector of probabilities, i.e., the upper bound of the integral.}

\item{cov}{Covariance matrix of the multivariate normal distribution. Must be semi-positive definite.
WARNING: for performance in high-dimensions, no check is performed on the matrix. It is the user responsibility to ensure
that this property is verified.}

\item{nu}{Degrees of freedom of the t distribution.}

\item{genVec}{Generating vector for the quasi-Monte Carlo procedure. Can be computed using \code{genVecQMC}.}
}
\value{
An estimate of the distribution function along with empirical Monte Carlo error.
}
\description{
Estimate the multivariate t distribution function with quasi-Monte Carlo method.
}
\details{
The function uses a quasi-Monte Carlo procedure based on randomly shifted
lattice rules to estimate the distribution function a multivariate normal distribution
as described in Genz, A. and Bretz, F.(2009).
}
\examples{

#Define locations
loc <- expand.grid(1:4, 1:4)
ref <- sample.int(16, 1)

#Defined degrees of freedom
nu <- 3

#Compute variogram matrix
variogramMatrix <- ((sqrt((outer(loc[,1],loc[,1],"-"))^2 +
(outer(loc[,2],loc[,2],"-"))^2)) / 2)^(1.5)

#Define an upper boud
upperBound <- variogramMatrix[-ref,ref]

#Compute covariance matrix
cov <-  (variogramMatrix[-ref,ref]\%*\%t(matrix(1, (nrow(loc) - 1), 1)) +
t(variogramMatrix[ref,-ref]\%*\%t(matrix(1, (nrow(loc) - 1), 1))) -
variogramMatrix[-ref,-ref])

#Compute generating vector
p <- 499
latticeRule <- genVecQMC(p, (nrow(loc) - 1))

#Estimate the multivariate distribution function
mvTProbQuasiMonteCarlo(latticeRule$primeP, upperBound, cov, nu, latticeRule$genVec)
}
\references{
Genz, A. and Bretz, F. (2009). Computations of Multivariate Normal and t Probabilities, volume 105. Springer, Dordrecht.

            Genz, A. (2013). QSILATMVTV \url{http://www.math.wsu.edu/faculty/genz/software/software.html}
}
