% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{multiverse_tree}
\alias{multiverse_tree}
\title{Plot a multiverse tree diagram.}
\usage{
multiverse_tree(
  .mverse,
  label = "none",
  branches = NULL,
  label_size = NULL,
  label_angle = 0,
  label_hjust = 0,
  label_vjust = 0
)
}
\arguments{
\item{.mverse}{A \code{mverse} object.}

\item{label}{Display the branch option name when "name" or the definition
when "code". No label is displayed when "none" (default).}

\item{branches}{A character vector. Display a subset of branches
when specified. Display all when NULL.}

\item{label_size}{A numeric. Set size of option labels.}

\item{label_angle}{A numeric. Rotate option labels.}

\item{label_hjust}{A numeric. Set the horizontal justification of the node
labels.}

\item{label_vjust}{A numeric. Set the vertical justification of the node
labels.}
}
\value{
A \code{ggplot} object displaying the multiverse tree.
}
\description{
A multiverse tree diagram displays the branching combination
of all the branches added to the given \code{mverse} object
taking any branch conditions defined. The method also allows
zooming into a subset of branches using \code{branches} parameter.
}
\examples{
{
# Display a multiverse tree with multiple branches.
outliers <- filter_branch(!Name \%in\% c("Katrina", "Audrey"), TRUE)
femininity <- mutate_branch(MasFem, Gender_MF)
strength <- mutate_branch(
  NDAM, HighestWindSpeed, Minpressure_Updated_2014, log(NDAM)
)
y <- mutate_branch(alldeaths, log(alldeaths + 1))
model <- formula_branch(y ~ femininity * strength, y ~ femininity + strength)
distribution <- family_branch(poisson, gaussian)
mv <- mverse(hurricane) \%>\%
  add_filter_branch(outliers) \%>\%
  add_mutate_branch(femininity, strength, y) \%>\%
  add_formula_branch(model) \%>\%
  add_family_branch(distribution)
multiverse_tree(mv)
# Display a multiverse tree with branch conditions.
match_poisson <- branch_condition(alldeaths, poisson)
match_log_lin <- branch_condition(log(alldeaths + 1), gaussian)
add_branch_condition(mv, match_poisson)
add_branch_condition(mv, match_log_lin)
multiverse_tree(mv)
# You can adjust colour scale of the edges
# using a ggraph::scale_edge_colour*() function.
multiverse_tree(mv) + ggraph::scale_edge_colour_viridis(
  discrete = TRUE,
  labels = c("Distribution", "Model", "Strength",
             "Femininity", "Outliers", "y")
)
# Display a multiverse tree for a subset of branches
# with name label for each option.
multiverse_tree(mv, branches = c("y", "distribution"), label = "name")
# with code label for each option.
multiverse_tree(mv, branches = c("y", "distribution"), label = "code")
# adjusting size and orientation of the labels
multiverse_tree(mv, branches = c("y", "distribution"),
  label = "name", label_size = 4, label_angle = 45)
}
}
