% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.mvgam.R
\name{loo.mvgam}
\alias{loo.mvgam}
\alias{loo_compare.mvgam}
\title{LOO information criteria for \code{mvgam} models}
\usage{
\method{loo}{mvgam}(x, ...)

\method{loo_compare}{mvgam}(x, ..., model_names = NULL)
}
\arguments{
\item{x}{Object of class \code{mvgam}}

\item{...}{More \code{mvgam} objects.}

\item{model_names}{If \code{NULL} (the default) will use model names derived
from deparsing the call. Otherwise will use the passed values as model names.}
}
\value{
for \code{loo.mvgam}, an object of class \code{psis_loo} (see \code{\link[loo:loo]{loo::loo()}}
for details). For \code{loo_compare.mvgam}, an object of class \code{compare.loo} (
\code{\link[loo:loo_compare]{loo::loo_compare()}} for details)
}
\description{
Extract the LOOIC (leave-one-out information criterion) using
\code{\link[loo:loo]{loo::loo()}}
}
\examples{
\dontrun{
# Simulate 4 time series with hierarchical seasonality
# and independent AR1 dynamic processes
set.seed(111)
simdat <- sim_mvgam(seasonality = 'hierarchical',
                   trend_model = AR(),
                   family = gaussian())

# Fit a model with shared seasonality
mod1 <- mvgam(y ~ s(season, bs = 'cc', k = 6),
             data = rbind(simdat$data_train,
             simdat$data_test),
             family = gaussian(),
             chains = 2)

# Inspect the model and calculate LOO
plot(mod1, type = 'smooths')
mc.cores.def <- getOption('mc.cores')
options(mc.cores = 1)
loo(mod1)

# Now fit a model with hierarchical seasonality
mod2 <- update(mod1,
              formula = y ~ s(season, bs = 'cc', k = 6) +
              s(season, series, bs = 'fs',
              xt = list(bs = 'cc'), k = 4),
              chains = 2)
plot(mod2, type = 'smooths')
loo(mod2)

# Now add AR1 dynamic errors to mod2
mod3 <- update(mod2,
              trend_model = AR(),
              chains = 2)
plot(mod3, type = 'smooths')
plot(mod3, type = 'trend')
loo(mod3)

# Compare models using LOO
loo_compare(mod1, mod2, mod3)
options(mc.cores = mc.cores.def)
}
}
