\name{mysort}
\alias{mysort}
\title{Sort a multivariate data matrix according to patterns of missingness}
\description{
  \code{mysort} sorts a multivariate data matrix so that records with
  identical patterns of missingness are adjacent to one another.
  \code{mysort} is a private function used inside of \code{mlest}.
}
\usage{
mysort(x)
}

\arguments{
  \item{x}{ A multivariate data matrix.  Rows correspond to individual
      records and columns correspond to components of the multivariate vector.}
}

\value{
  \item{sorted.data}{A matrix of the same size as \code{x} but with the
      rows re-arranged so that records with identical patterns of
      missingness are adjacent to one another.}
  \item{freq}{An integer vector giving the number of records in each
      block of rows with a unique pattern of missingness.  The first
      element in \code{freq} counts the number of rows in the top block
      of \code{sorted.data}, and so on.}
}

\seealso{ \code{\link{mlest}} }

\keyword{multivariate}
