% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mvord.control}
\alias{mvord.control}
\title{Control functions for mvord()}
\usage{
mvord.control(
  se = TRUE,
  start.values = NULL,
  combis = NULL,
  solver = "newuoa",
  solver.optimx.control = list(maxit = 2e+05, trace = 0, kkt = FALSE)
)
}
\arguments{
\item{se}{logical, if \code{TRUE} standard errors are computed.}

\item{start.values}{list of (optional) starting values for thresholds and coefficients.}

\item{combis}{list of length equal to the number of combinations of responses that should enter the pairwise likelihood. Each element contains one pair of integers corresponding to two responses. Defaults to NULL, in which case all pairs are considered.
Should only be used if user knows the ordering of the responses in the analysis.}

\item{solver}{character string containing the name of the applicable solver of \code{\link[optimx]{optimx}} (default is \code{"newuoa"})
or wrapper function for user defined solver.}

\item{solver.optimx.control}{a list of control arguments to be passed to \code{\link[optimx]{optimx}}. See \code{\link[optimx]{optimx}}.}
}
\description{
Control arguments are set for \code{mvord()}.
}
\seealso{
\code{\link{mvord}}
}
