% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_normalize.R
\name{mx_normalize}
\alias{mx_normalize}
\title{Normalizes multiplexed data}
\usage{
mx_normalize(
  mx_data,
  transform = "None",
  method = "None",
  method_override = NULL,
  method_override_name = NULL,
  ...
)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object to normalize}

\item{transform}{transformation to perform on the input data. Options include: c("None", "log10", "mean_divide","log10_mean_divide")}

\item{method}{normalization method to perform on the input data. Options include: c("None", "ComBat","Registration")}

\item{method_override}{optional user-defined function to perform own normalization method (default=NULL). If using a user-defined function, it must include a \code{mx_data} parameter.}

\item{method_override_name}{optional name for method_override (default=NULL).}

\item{...}{optional additional arguments for normalization functions}
}
\value{
Multiplexed data normalized according to the method specified, in the \code{mx_dataset} format. Normalized data will be included a new table with normalized values and attributes describing the transformation.
}
\description{
Normalizes some given image input according to the method specified
}
\examples{
mx_data = mx_dataset(mxnorm::mx_sample, "slide_id", "image_id",
  c("marker1_vals","marker2_vals","marker3_vals"),
  c("metadata1_vals"))
mx_data = mx_normalize(mx_data, transform="log10",method="None")
}
