% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mycor}
\alias{mycor}
\alias{mycor.default}
\alias{mycor.formula}
\title{Perform correlation and linear regression for a data.frame automatically}
\usage{
mycor(x, ..., digits)

\method{mycor}{default}(x, ..., digits = 3)

\method{mycor}{formula}(formula, data, ..., digits = 3)
}
\arguments{
\item{x}{A data.frame.}

\item{...}{further arguments to be passed to \code{\link{cor.test}}.}

\item{digits}{integer indicating the number of decimal places (round) or
significant digits (signif) to be used.}

\item{formula}{a formula of the form ~ u + v, where each of u and v are
numeric variables giving the data values for one sample. The samples
must be of the same length.}

\item{data}{A data.frame}

\item{mycor}{Object to mycor}
}
\value{
mycor returns as object of class "mycor"

    The function summary is used to print a summary of the result. The function
    plot is used to plot the results using \code{\link{pairs}} and \code{\link[lattice]{parallelplot}}.

    An object of class "mycor:" is a list containing at least following components:
    \describe{
       \item{df}{a data.frame}
       \item{select}{logical vectors returns if columns of df is.numeric}
       \item{out}{a list of class "htest" from \code{\link{cor.test}}
          between the last paired samples in a data.frame.}
       \item{r}{a matrix consist of r values from \code{\link{cor.test}}
          between all pairs of numeric data from a data.frame}
       \item{p}{a matrix consist of p values from \code{\link{cor.test}}
          between all pairs of numeric data from a data.frame}
       \item{slope}{a matrix consist of slope values from \code{\link{lm}}
          between all pairs of numeric data from a data.frame}
       \item{intercept}{a matrix consist of intercept values from \code{\link{lm}}
          between all pairs of numeric data from a data.frame}
    }
}
\description{
Perform correlation and linear regression for a data.frame automatically
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: for class data.frame

\item \code{formula}: for class "formula"
}}
\examples{
out=mycor(iris)
 plot(out)
 plot(out, groups=Species)
 plot(out,type=2,groups=species)
 plot(out,type=4,groups=species)
 out1=mycor(~mpg+disp+wt+hp,data=mtcars,alternative="greater",methods="kendall",
            conf.level=0.95)
 plot(out1,type=3)
 plot(out1,type=4,groups=cyl)
}

