% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n1qn1.R
\name{qnbd}
\alias{qnbd}
\title{qnbd optimization}
\usage{
qnbd(par, fn, gr, lower = -Inf, upper = Inf,
  environment = parent.frame(1),
  zero = sqrt(.Machine$double.eps/7e-07), maxFn = 10000L,
  maxIt = 10000L, epsf = sqrt(.Machine$double.eps),
  epsg = sqrt(.Machine$double.eps), epsx = sqrt(.Machine$double.eps),
  print.functions = FALSE)
}
\arguments{
\item{par}{Initial parameter estimate}

\item{fn}{Function}

\item{gr}{Gradient}

\item{lower}{Lower Bound for optimization}

\item{upper}{Upper Bound for optimization}

\item{environment}{Environment where call_eval/call_grad are
evaluated.}

\item{zero}{Tolerance for Zero}

\item{maxFn}{Maximum function evaluations}

\item{maxIt}{Maximum iterations}

\item{epsf}{Function eps for exiting}

\item{epsg}{Gradient eps for exiting}

\item{epsx}{Parameter eps for exiting}

\item{print.functions}{Boolean to control if the function value
and parameter estimates are echoed every time a function is
called.}
}
\description{
This is an R port of the qnbd which is a BFGS-B optimization
procedure in scilab. (R has L-BFGS-B in optim).
}
\examples{

## Rosenbrock's banana function
n=3; p=100

fr = function(x)
{
    f=1.0
    for(i in 2:n) {
        f=f+p*(x[i]-x[i-1]**2)**2+(1.0-x[i])**2
    }
    f
}

grr = function(x)
{
    g = double(n)
    g[1]=-4.0*p*(x[2]-x[1]**2)*x[1]
    if(n>2) {
        for(i in 2:(n-1)) {
            g[i]=2.0*p*(x[i]-x[i-1]**2)-4.0*p*(x[i+1]-x[i]**2)*x[i]-2.0*(1.0-x[i])
        }
    }
    g[n]=2.0*p*(x[n]-x[n-1]**2)-2.0*(1.0-x[n])
    g
}

x = c(1.02,1.02,1.02)

op1 <- qnbd(x, fr, grr)

}
