% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.unreplace.R
\name{na.unreplace}
\alias{na.unreplace}
\alias{na.unreplace.default}
\alias{na.unreplace.character}
\alias{na.unreplace.factor}
\alias{na.implicit}
\title{na.unreplace}
\usage{
na.unreplace(x, values)

\method{na.unreplace}{default}(x, values = NULL)

\method{na.unreplace}{character}(x, values = c("NA", NA_explicit_))

\method{na.unreplace}{factor}(x, values = c("NA", NA_explicit_))

na.implicit(x, values)
}
\arguments{
\item{x}{object}

\item{values}{values that are (or can be coerced to) \code{class(x)} that are to
be set to \code{NA}.}
}
\description{
Change values to NAs, ie make explicit \code{NAs} back to \code{NA}
}
\details{
\code{na.unreplace} replaces \code{values} by \code{NA}. It is meant to be nearly inverse
operation to \code{na_replace} (and \code{na_explicit}). It can be used on both atomic
and recursive objects. Unlike  \code{na.replace} however, \code{values} express the
values that if matched are set to \code{NA}.  It is basically:\preformatted{x[ x %in% values ] <- NA
}

\code{na.unreplace} is a S3 method that can be used to defince additional
methods for other objects.
}
\examples{

 na.unreplace( c(1,2,3,4), 3 )
 na.unreplace( c("A", "(NA)", "B", "C") )
 na.unreplace( c("A", NA_explicit_, "B", "C") )
 
 df <- data.frame( char=c('A', 'NA', 'C', NA_explicit_), num=1:4 ) 
 na.unreplace(df)
 
 
}
\seealso{
\itemize{
\item \code{\link[=na.replace]{na.replace()}}
}
}
