% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions.R
\name{states}
\alias{states}
\title{States of the Federal Republic of Nigeria}
\usage{
states(states, gpz = NULL, all = TRUE)
}
\arguments{
\item{states}{One or more States of the Federation}

\item{gpz}{Geopolitical zone. Default is \code{NULL}; optionally \code{"nc",
"ne", "nw", "se", "ss"} and \code{"sw"} (see "Details").}

\item{all}{logical; whether to include the Federal Capital Territory in 
the result}
}
\value{
The States of Nigeria as a whole or by zones, as an S3 object 
of class \code{states}.
}
\description{
States of the Federal Republic of Nigeria
}
\details{
gpz A geo-political zone, in the Nigerian 
context, is a national subdivision that groups contiguous states. 
Historically, they arise from subnational administrative divisions 
known as 'regions' that existed at the time of the country's independence.
There are 6 zones - North-Central, North-East, North-West, South-East,
South-South and South-West.
}
\examples{
states()  # lists names of all States
states(gpz = "se")  # lists States in South-East zone
}
