% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_chunks.R
\name{name_chunks}
\alias{name_chunks}
\title{Name chunks in a single file}
\usage{
name_chunks(path, unname = FALSE)
}
\arguments{
\item{path}{Path to file}

\item{unname}{Should all chunks be unnamed before naming? Default is `FALSE`.
Turning this option on will cause all existing labels to be overwritten. In
contrast, with its default `unname = FALSE` only unlabelled chunks will be
named.}
}
\value{
Always returns TRUE invisibly. Called for side effects.
}
\description{
Name unnamed chunks in a single file using the filename with extension stripped as basis.
}
\details{
When using namer, please check the edits
 before pushing them to your code base. Such automatic
 chunk labelling is best paired with version control.
}
\examples{
temp_file_path <- file.path(tempdir(), "test.Rmd")
file.copy(system.file("examples", "example1.Rmd", package = "namer"),
          temp_file_path,
          overwrite = TRUE)
name_chunks(temp_file_path)
if(interactive()){
file.edit(temp_file_path)
}
file.remove(temp_file_path)
}
