# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

ReflectIndexMed <- function(vec, ind, side) {
    .Call('nandb_ReflectIndexMed', PACKAGE = 'nandb', vec, ind, side)
}

Smooth <- function(vec) {
    .Call('nandb_Smooth', PACKAGE = 'nandb', vec)
}

MedReflectExtend <- function(vec, preserve_mean = FALSE, smooth = FALSE) {
    .Call('nandb_MedReflectExtend', PACKAGE = 'nandb', vec, preserve_mean, smooth)
}

MedReflectExtendRows <- function(rows, preserve_mean = FALSE, smooth = FALSE) {
    .Call('nandb_MedReflectExtendRows', PACKAGE = 'nandb', rows, preserve_mean, smooth)
}

#' Exponentially smooth a series of observations.
#'
#' This function assumes that the observations are evenly spaced and separated
#' by 1 time unit (so choose your \code{tau} based on that).
#'
#' @param obs A numeric vector of observations (in order).
#' @param tau The time scale for the exponential smoothing (see Stroud 1999).
#' @param extended Logical. Has the series (`obs`) already been extended via
#'   via `nandb:::MedReflectExtend()`? If not, \code{ExpSmooth} will do this
#'   prior to smoothing as an edge-correction technique. You will probably
#'   never set this to \code{TRUE}, but [BestTau()] needs this feature.
#'
#' @return The smoothed series, a numeric vector of the same length.
#' @examples
#' ExpSmooth(1:10, 1)
#' @export
ExpSmooth <- function(obs, tau, extended = FALSE) {
    .Call('nandb_ExpSmooth', PACKAGE = 'nandb', obs, tau, extended)
}

ExpSmoothNaive <- function(obs, tau) {
    .Call('nandb_ExpSmoothNaive', PACKAGE = 'nandb', obs, tau)
}

#' Exponentially smooth pillars of a 3-dimensional array
#'
#' For a 3-dimensional array \code{mat3d}, pillar \code{i,j} is defined as
#' \code{mat3d[i, j, ]}. \code{ExpSmoothPillars} function performs
#' \link{ExpSmooth} on each pillar. \code{ExpSmoothRows} performs
#' \link{ExpSmooth} on each row of a matrix.
#'
#' @param mat3d A 3-dimensional array.
#' @param tau The time scale for the exponential smoothing (see Stroud 1999).
#'
#' @return For \code{ExpSmoothPillars}, a 3-dimensional array where each
#' pillar has been smoothed. For \code{ExpSmoothRows}, a matrix where each
#' row has been smoothed.
#'
#' @examples
#' m3 <- array(1:12, dim = c(2, 2, 3))
#' ExpSmoothPillars(m3, 7)
#' @export
ExpSmoothPillars <- function(mat3d, tau) {
    .Call('nandb_ExpSmoothPillars', PACKAGE = 'nandb', mat3d, tau)
}

#' @rdname ExpSmoothPillars
#' @param mat A matrix.
#' @param extended Logical. Has the series (`obs`) already been extended via
#'   via `nandb:::MedReflectExtend()`? If not, \code{ExpSmooth} will do this
#'   prior to smoothing as an edge-correction technique. You will probably
#'   never set this to \code{TRUE}, but [BestTau()] needs this feature.
#' @export
ExpSmoothRows <- function(mat, tau, extended = FALSE) {
    .Call('nandb_ExpSmoothRows', PACKAGE = 'nandb', mat, tau, extended)
}

#' Smooth and median filters with options for handling NAs.
#'
#' These is an alternative to [EBImage][EBImage::EBImage]'s
#' [filter2][EBImage::filter2] and [medianFilter][EBImage::medianFilter] for
#' smooth and median filtering respectively. These functions have many options
#' for dealing with \code{NA} values which \code{EBImage}'s functions lack.
#'
#' The behavior at image boundaries is such as the source image has been padded
#' with pixels whose values equal the nearest border pixel value.
#'
#' @param mat A matrix (representing an image).
#' @param size An integer; the median filter radius.
#' @param na_rm Should \code{NA}s be ignored?
#' @param na_count If this is TRUE, in each median calculation, if the majority
#' of arguments are \code{NA}s, \code{NA} is returned but if the \code{NA}s are
#' in the minority, they are ignored as in \code{median(x, na.rm = TRUE)}.
#'
#' @return A matrix (the median filtered image).
#'
#' @examples
#' m <- matrix(1:9, nrow = 3)
#' m[2:3, 2:3] <- NA
#' print(m)
#' MedianFilterB(m)
#' MedianFilterB(m, na_rm = TRUE)
#' MedianFilterB(m, na_count = TRUE)
#'
#' @export
MedianFilterB <- function(mat, size = 1L, na_rm = FALSE, na_count = FALSE) {
    .Call('nandb_MedianFilterB', PACKAGE = 'nandb', mat, size, na_rm, na_count)
}

#' @rdname MedianFilterB
#'
#' @examples
#' MedianFilterB(m)
#' MedianFilterB(m, na_rm = TRUE)
#' MedianFilterB(m, na_count = TRUE)
#'
#' @export
SmoothFilterB <- function(mat, size = 1L, na_rm = FALSE, na_count = FALSE) {
    .Call('nandb_SmoothFilterB', PACKAGE = 'nandb', mat, size, na_rm, na_count)
}

#' Get the means/medians/variances of pillars of a 3d array
#'
#' For a 3-dimensional array \code{mat3d}, pillar \code{ij} is defined as
#' \code{mat3d[i, j, ]}. These functions compute the mean, median and variance of each
#' pillar.
#'
#' @param mat3d A 3-dimensional array.
#'
#' @return A matrix where element \code{i,j} is equal to \code{mean(mat3d[i, j, ])},
#' \code{median(mat3d[i, j, ])}, or \code{var(mat3d[i, j, ])}.
#'
#' @examples
#' m3 <- array(1:16, dim = c(2, 2, 4))
#' MeanPillars(m3)
#' MedianPillars(m3)
#' VarPillars(m3)
#'
#' @export
MeanPillars <- function(mat3d) {
    .Call('nandb_MeanPillars', PACKAGE = 'nandb', mat3d)
}

#' @rdname MeanPillars
#' @export
VarPillars <- function(mat3d) {
    .Call('nandb_VarPillars', PACKAGE = 'nandb', mat3d)
}

#' @rdname MeanPillars
#' @export
MedianPillars <- function(mat3d) {
    .Call('nandb_MedianPillars', PACKAGE = 'nandb', mat3d)
}

WhichIntervalC <- function(numbers, ranges) {
    .Call('nandb_WhichIntervalC', PACKAGE = 'nandb', numbers, ranges)
}

SpreadSpecificHelper <- function(interval_lengths, interval_pops, m) {
    .Call('nandb_SpreadSpecificHelper', PACKAGE = 'nandb', interval_lengths, interval_pops, m)
}

