% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{CollapseRanges}
\alias{CollapseRanges}
\title{Collapse a big set of ranges into a smaller set.}
\usage{
CollapseRanges(ranges, n.out, preserve = NULL, prefer.low = FALSE,
  prefer.high = FALSE)
}
\arguments{
\item{ranges}{A strictly increasing (numeric) vector. Each set of adjacent
elements are interpreted as the bounds of a range (or bin).}

\item{n.out}{A natural number. How many ranges should the output have?}

\item{preserve}{A vector. Are there any original ranges that you'd like to
preserve? If so set them here. The first range is the interval
\code{[ranges[1], ranges[2])} and so on.}

\item{prefer.low}{Are you more interested in the lower ranges? If so, set
this to true and all the high ranges will be collapsed into one.}

\item{prefer.high}{Are you more interested in the higher ranges? If so, set
this to true and all the high ranges will be collapsed into one.}
}
\value{
A vector of the new ranges.
}
\description{
Say you have many ranges (or bins) in which you're assigning continuous
values and you'd like to collapse these ranges such that there are fewer of
them (but they still cover the same part of that continuous scale). This
function is here to help.
}
\details{
One property of this procedure is that each new range is the union of old
ranges.
}
\examples{
set.seed(0)
ranges <- sort(sample(1:100, 11))
print(ranges)
CollapseRanges(ranges, 6, c(3, 7))
CollapseRanges(ranges, 6, c(3, 7), prefer.low = TRUE)
CollapseRanges(ranges, 6, c(3, 7), prefer.high = TRUE)
}
