% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness.R
\name{brightness_folder}
\alias{brightness_folder}
\title{Brightness calculations for every image in a folder.}
\usage{
brightness_folder(folder_path = ".", def, tau = NULL, thresh = NULL,
  filt = NULL, correct = FALSE, s = 1, offset = 0, readout_noise = 0,
  parallel = FALSE)
}
\arguments{
\item{folder_path}{The path (relative or absolute) to the folder you wish to
process.}

\item{def}{A character. Which definition of brightness do you want to use,
\code{"B"} or \code{"epsilon"}?}

\item{tau}{The \eqn{tau} parameter for \emph{exponential filtering} detrending.
This must be a positive number. Set this to "auto" to use Nolan's algorithm
to automatically find a suitable value for this parameter (recommended).
For multi-channel images, it is possible to have a different \code{tau} for each
channel by specifying \code{tau} as a vector or list.}

\item{thresh}{The threshold or thresholding method (see
\code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}}) to use on the image prior to
detrending and brightness calculations.}

\item{filt}{Do you want to smooth (\code{filt = 'mean'}) or median (\code{filt = 'median'}) filter the number image using \code{\link[=smooth_filter]{smooth_filter()}} or
\code{\link[=median_filter]{median_filter()}} respectively? If selected, these are invoked here with a
filter radius of 1 (with corners included, so each median is the median of
9 elements) and with the option \code{na_count = TRUE}. If you want to
smooth/median filter the number image in a different way, first calculate
the numbers without filtering (\code{filt = NULL}) using this function and then
perform your desired filtering routine on the result.}

\item{correct}{Apply the number/brightness correction detailed in equation 7
of Hur et al. (2014). This is another correction for the effects of
bleaching and is needed in addition to the more conventional correction
controlled by the \code{tau} parameter.}

\item{s}{A number. The \eqn{S}-factor of microscope acquisition.}

\item{offset}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{readout_noise}{Microscope acquisition parameters. See reference
Dalal et al.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\description{
Perform \code{\link[=brightness]{brightness()}} calculations on all tif images in a folder and save the
resulting brightness images to disk.
}
\examples{
\dontrun{
setwd(tempdir())
img <- ijtiff::read_tif(system.file('extdata', '50.tif', package = 'nandb'))
ijtiff::write_tif(img, 'img1.tif')
ijtiff::write_tif(img, 'img2.tif')
brightness_folder(def = "B", tau = NA, thresh = "Huang", parallel = 2)
}
}
\seealso{
\code{\link[=number]{number()}}
}
