% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoped-replace-with-na.R
\name{replace_with_na_at}
\alias{replace_with_na_at}
\title{Replace specified variables with NA where a certain condition is met}
\usage{
replace_with_na_at(data, .vars, condition)
}
\arguments{
\item{data}{dataframe}

\item{.vars}{A character string of variables to replace with NA values}

\item{condition}{A condition required to be TRUE to set NA. Here, the condition
is specified with a formula, following the syntax: \code{~.x {condition}}.
For example, writing \code{~.x < 20} would mean "where a variable value is less
than 20, replace with NA".}
}
\value{
a dataframe
}
\description{
Replace specified variables with NA where a certain condition is met
}
\examples{

dat_ms <- tibble::tribble(~x,  ~y,    ~z,
                          1,   "A",   -100,
                          3,   "N/A", -99,
                          NA,  NA,    -98,
                          -99, "E",   -101,
                          -98, "F",   -1)

dat_ms

replace_with_na_at(data = dat_ms,
                 .vars = "x",
                 condition = ~.x == -99)

replace_with_na_at(data = dat_ms,
                 .vars = c("x","z"),
                 condition = ~.x == -99)

# replace using values in common_na_strings
replace_with_na_at(data = dat_ms,
                 .vars = c("x","z"),
                 condition = ~.x \%in\% common_na_strings)


}
