% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoped-replace-with-na.R
\name{replace_with_na_if}
\alias{replace_with_na_if}
\title{Replace values with NA based on some condition, for variables that meet some predicate}
\usage{
replace_with_na_if(data, .predicate, condition)
}
\arguments{
\item{data}{Dataframe}

\item{.predicate}{A predicate function to be applied to the columns or a
logical vector.}

\item{condition}{A condition required to be TRUE to set NA. Here, the condition
is specified with a formula, following the syntax: \verb{~.x \{condition\}}.
For example, writing \code{~.x < 20} would mean "where a variable value is less
than 20, replace with NA".}
}
\value{
Dataframe
}
\description{
Replace values with NA based on some condition, for variables that meet some predicate
}
\examples{

dat_ms <- tibble::tribble(~x,  ~y,    ~z,
                          1,   "A",   -100,
                          3,   "N/A", -99,
                          NA,  NA,    -98,
                          -99, "E",   -101,
                          -98, "F",   -1)

dat_ms

replace_with_na_if(data = dat_ms,
                 .predicate = is.character,
                 condition = ~.x == "N/A")
replace_with_na_if(data = dat_ms,
                   .predicate = is.character,
                   condition = ~.x \%in\% common_na_strings)

replace_with_na(dat_ms,
              to_na = list(x = c(-99, -98),
                           y = c("N/A"),
                           z = c(-101)))


}
