% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nano_init}
\alias{nano_init}
\title{nanonext Initialise}
\usage{
nano_init(warn = c("immediate", "deferred", "error", "none"))
}
\arguments{
\item{warn}{[default 'immediate'] character string defining how to treat
warnings generated by the package. 'immediate' to print warnings as they
occur, 'deferred' to print warnings when evaluation returns to the top
level, 'error' to upgrade all warnings to errors (stops execution), and
'none' to ignore all warnings.}
}
\value{
Invisibly, the integer \code{code} applied to \code{options(warn = code)}.
}
\description{
Initialise global options - intended to be called immediately after package load.
}
\section{Warnings}{


    A warning is generated every time an 'errorValue' is returned.

    This function sets the global option 'warn' to the appropriate value and
    automatically reverts it upon package unload. The default, applied by
    calling \code{nano_init()} with no arguments, is 'immediate', which
    prints warnings as they occur.

    Further options for warnings may be set manually via \code{\link{options}}:

    \itemize{

    \item{warning.expression} { - an R code expression to be called if a
    warning is
    generated, replacing the standard message. If non-null it is called
    irrespective of the value of option warn.}

    \item{warning.length} { - sets the truncation limit in bytes for error and warning
    messages. A non-negative integer, with allowed values 100...8170, default
    1000.}

    \item{nwarnings} { - the limit for the number of warnings kept when warn = 0,
    default 50. This will discard messages if called whilst they are being
    collected. If you increase this limit, be aware that the current
    implementation pre-allocates the equivalent of a named list for them.}
    }
}

