library(nanonext)
nanotest <- function(x) invisible(x || stop("is not TRUE when expected to be TRUE"))
nanotestw <- function(x) invisible(suppressWarnings(x) || stop("is not TRUE when expected to be TRUE"))
nanotestz <- function(x) invisible(x == 0L || stop("does not equal 0L as expected"))
nanotestaio <- function(x) invisible(is_aio(x) || stop("is not of class 'recvAio' or 'sendAio' as expected"))
nanotestnano <- function(x) invisible(is_nano(x) || stop("does not inherit from class 'nano' as expected"))
nanotestn <- function(x) invisible(is.null(x) || stop("is not NULL when expected to be NULL"))
nanotestnn <- function(x) invisible(!is.null(x) || stop("is NULL when expected to be not NULL"))
nanotestp <- function(x) invisible(is.character(capture.output(print(x))) || stop("print output of expression cannot be captured as a character value"))
nanotestxp <- function(x) invisible(typeof(x) == "externalptr" || stop("is not of type 'externalptr' as expected"))
nanotesterr <- function(x, e = "")
  invisible(grepl(e, tryCatch(x, error = identity)[["message"]], fixed = TRUE) || stop("expected error message '", e, "' not generated"))

nng_version()
nanotestnano(n <- nano("pair", listen = "inproc://nanonext", autostart = FALSE))
nanotestnano(n1 <- nano("pair", dial = "inproc://nanonext", autostart = FALSE))
nanotest(inherits(n, "nanoObject"))
nanotest(inherits(n$socket, "nanoSocket"))
nanotest(inherits(n$socket, "nano"))
nanotestnano(n)
n$newmethod <- "doesnotwork"
nanotestn(n$newmethod)
nanotest(is.integer(attr(n$socket, "id")))
nanotest(n$socket$state == "opened")
nanotest(n$socket$protocol == "pair")
nanotest(n$send("not ready") == 8L)
nanotest(n$recv() == 8L)
nanotestnano(n$opt("recv-size-max", 8192))
nanotest(n$opt("recv-size-max") == 8192L)
nanotestnano(n$opt("recv-buffer", 8L))
nanotestnano(n$opt("socket-name", "nano"))
nanotest(n$opt("socket-name") == "nano")
nanotesterr(n$opt("socket-name", NULL), "argument")
nanotestp(n$listener[[1]])
nanotest(inherits(n$listener[[1]], "nanoListener"))
nanotest(n$listener[[1]]$url == "inproc://nanonext")
nanotest(n$listener[[1]]$state == "not started")
nanotestnano(n$listener_opt("recv-size-max", 1024)[[1L]])
nanotest(n$listener_opt("recv-size-max")[[1L]] == 1024L)
nanotesterr(n$listener_opt("false", 100), "supported")
nanotesterr(n$listener_opt("false"), "supported")
nanotesterr(n$listener_opt("false", "false"), "supported")
nanotesterr(n$listener_opt("false", NULL), "supported")
nanotesterr(n$listener_opt("false", TRUE), "supported")
nanotesterr(n$listener_opt("false", list()), "type")
nanotestz(n$listener_start())
nanotest(n$listener[[1]]$state == "started")
nanotestp(n1$dialer[[1]])
nanotest(inherits(n1$dialer[[1]], "nanoDialer"))
nanotest(n1$dialer[[1]]$url == "inproc://nanonext")
nanotest(n1$dialer[[1]]$state == "not started")
nanotestnano(n1$dialer_opt("reconnect-time-min", 1000)[[1L]])
nanotest(n1$dialer_opt("reconnect-time-min")[[1L]] == 1000L)
nanotestnano(n1$dialer_opt("recv-size-max", 8192)[[1L]])
nanotest(n1$dialer_opt("recv-size-max")[[1L]] == 8192L)
nanotesterr(n1$dialer_opt("false", 100), "supported")
nanotesterr(n1$dialer_opt("false"), "supported")
nanotesterr(n1$dialer_opt("false", "false"), "supported")
nanotesterr(n1$dialer_opt("false", NULL), "supported")
nanotesterr(n1$dialer_opt("false", TRUE), "supported")
nanotesterr(n1$dialer_opt("false", list()), "type")
nanotestz(n1$dialer_start())
nanotest(n1$dialer[[1]]$state == "started")

nanotesterr(n$send(list(), mode = "raw"), "atomic vector type")
nanotesterr(n$recv(mode = "none"), "mode")
nanotesterr(n$recv(mode = "c"), "mode")
nanotestaio(raio <- n$recv_aio(timeout = 1L))
nanotestp(raio)
nanotest(is_error_value(call_aio(raio)$data))
nanotest(is_error_value(raio$data))
nanotestz(n$send(data.frame(), block = FALSE))
nanotest(is.list(n1$recv(block = FALSE, keep.raw = TRUE)))
nanotestz(n1$send("test", mode = "raw", block = 500))
nanotest(n$recv("character", block = 500, keep.raw = TRUE)$data == "test")
nanotestz(n1$send(c(1L, 0L, 0L), mode = "r"))
nanotest(is.list(n$recv("int", keep.raw = TRUE)))
nanotestaio(saio <- n$send_aio(data.frame(random(1e4L)), timeout = 900))
nanotestp(saio)
nanotestaio(call_aio(saio))
nanotest(!is_nano(saio))
nanotest(is.integer(saio$result))
nanotesterr(n$send("wrong mode", mode = "none"), "mode")
nanotestaio(raio <- n1$recv_aio(timeout = 500, keep.raw = TRUE))
nanotestp(raio)
raio$newfield <- "doesnotwork"
raio[["newfield"]] <- "doesnotwork"
nanotestn(raio$newfield)
nanotestaio(saio <- n$send_aio(c(1.1, 2.2), mode = "raw", timeout = 500))
saio$newfield <- "doesnotwork"
saio[["newfield"]] <- "doesnotwork"
nanotestn(saio$newfield)
nanotest(is.logical(.unresolved(saio)))
nanotest(is.logical(unresolved(saio)))
nanotestnn(raio$raw)
nanotest(identical(unserialize(call_aio(raio)$raw), raio$data))
nanotestaio(msg <- n1$recv_aio(mode = "numer", keep.raw = TRUE, timeout = 500))
nanotest(identical(call_aio(msg), msg))
nanotestaio(msg <- n1$recv_aio(mode = "complex", keep.raw = TRUE, timeout = 500))
nanotestn(stop_aio(msg))
nanotestn(stop_aio(n))
nanotest(identical(call_aio(msg), msg))
nanotesterr(msg$raw, "active")
nanotesterr(msg$data, "active")
nanotest(identical(call_aio(n), n))
nanotest(!is_aio(n))
nanotestaio(sraio <- n$send_aio(as.raw(0L), mode = "r", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "r", timeout = 500))
nanotest(is.raw(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(c(1+2i, 4+3i), mode = "ra", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "co", timeout = 500))
nanotest(is.complex(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(5, mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "d", timeout = 500))
nanotest(is.double(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(c(1, 2), mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "n", timeout = 500))
nanotest(is.numeric(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(c(1L, 2L, 3L), mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "i", timeout = 500))
nanotest(is.integer(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "double", timeout = 500))
nanotestw(is.raw(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "int", timeout = 500))
nanotestw(is.raw(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "logical", timeout = 500))
nanotestw(is.raw(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio(as.raw(0L), mode = "raw", timeout = 500))
nanotestaio(rraio <- n1$recv_aio(mode = "numeric", timeout = 500))
nanotestw(is.raw(call_aio(rraio)$data))
nanotestaio(sraio <- n$send_aio("hello", mode = 2L, timeout = 500))
assign("aio", value = "test", envir = sraio)
nanotesterr(sraio$result, "valid")
nanotestaio(rraio <- n1$recv_aio(mode = "characte", keep.raw = TRUE, timeout = 500))
nanotesterr(opt(rraio[["aio"]], "false") <- 0L, "valid")
nanotesterr(subscribe(rraio[["aio"]], "false"), "valid")
nanotesterr(opt(rraio[["aio"]], "false"), "valid")
nanotesterr(stat(rraio[["aio"]], "pipes"), "valid")
assign("aio", value = "test", envir = rraio)
nanotesterr(rraio$raw, "valid")
nanotesterr(rraio$data, "valid")

nanotestz(n$dial(url = "inproc://two", autostart = FALSE))
nanotestz(n$dialer_start())
nanotest(inherits(n$dialer[[1L]], "nanoDialer"))
nanotest(is.double(stat(n$dialer[[1L]], "id")))
nanotestz(n$listen(url = "inproc://three", autostart = FALSE))
nanotestz(n$listener_start())
nanotest(inherits(n$listener[[2L]], "nanoListener"))
nanotest(is.double(stat(n$listener[[2L]], "id")))
nanotestz(n$dial(url = "inproc://four"))
nanotestz(close(n$listener[[1]]))
nanotestw(close(n$listener[[1]]) == 12L)
nanotestz(close(n1$dialer[[1]]))
nanotestw(close(n1$dialer[[1]]) == 12L)
nanotestz(n$close())
nanotestz(n1$close())
nanotestw(n1$close() == 7L)
nanotest(n$socket[["state"]] == "closed")
nanotest(n1$socket[state] == "closed")

nanotestnano(req <- nano("req", listen = "inproc://testing"))
nanotestnano(rep <- socket("rep", dial = "inproc://testing", listen = "inproc://testing2"))
nanotestp(rep)
if (nng_version()[1] == "1.6.0pre") {
  nanotest(stat(rep, "dialers") == 1)
  nanotest(stat(rep, "protocol") == "rep")
}
nanotestn(stat(rep, "nonexistentstat"))
nanotestnano(req$opt("req:resend-time", 1000))
nanotest(req$opt("req:resend-time") == 1000L)
nanotesterr(req$opt("none"), "supported")
nanotestxp(req$context_open())
nanotest(inherits(req$context, "nanoContext"))
nanotest(inherits(req$context, "nano"))
nanotest(is.integer(req$context$id))
nanotest(req$context$state == "opened")
nanotest(req$context$protocol == "req")
nanotestnano(req$opt("send-timeout", 1000))
nanotest(req$opt("send-timeout") == 1000L)
nanotesterr(req$opt("false", 100), "supported")
nanotesterr(req$opt("false"), "supported")
nanotesterr(req$opt("false", "false"), "supported")
nanotesterr(req$opt("false", NULL), "supported")
nanotesterr(req$opt("false", TRUE), "supported")
nanotesterr(req$opt("false", list()), "type")
nanotestnano(ctx <- context(rep))
nanotestp(ctx)
nanotestaio(csaio <- req$send_aio(data.frame(), mode = "seria", timeout = 500))
nanotest(is.integer(call_aio(csaio)$result))
nanotestaio(craio <- recv_aio(ctx, timeout = 500))
nanotest(is.list(.subset2(call_aio(craio), "data")))
nanotest(is.integer(req$send("context test", mode ="raw", block = 500)))
nanotest(recv(ctx, mode = "ch", block = 500) == "context test")
nanotestnn(req$send(data.frame(), mode = "seri", block = 500))
nanotestaio(msg <- recv_aio(ctx, mode = "ser", timeout = 500, keep.raw = FALSE))
nanotest(is.logical(.unresolved(msg)))
nanotest(is.logical(unresolved(msg)))
nanotest(is.list(call_aio(msg)$data))
nanotest(!unresolved(msg))
nanotest(is.integer(req$send(c(TRUE, FALSE, TRUE), mode = 2L, block = 500)))
nanotestaio(msg <- recv_aio(ctx, mode = 6L, timeout = 500, keep.raw = TRUE))
nanotest(is.raw(call_aio(msg)$raw))
nanotestaio(err <- send_aio(ctx, "test"))
nanotestn(stop_aio(err))
nanotesterr(err$result, "active")
nanotestaio(err <- send_aio(ctx, "test"))
nanotest(is_error_value(call_aio(err)$result))
nanotestaio(rek <- request(req$context, c(1+3i, 4+2i), recv_mode = "complex", timeout = 500, keep.raw = TRUE))
nanotest(is.integer(reply(ctx, execute = identity, send_mode = "ra", timeout = 500)))
nanotest(is.complex(call_aio(rek)[["data"]]))

nanotest(inherits(cv <- cv(), "conditionVariable"))
nanotestp(cv)
nanotest(until(cv, 10L))
nanotest(until(cv, 10))
nanotestn(cv_reset(cv))
nanotestz(cv_value(cv))
nanotestaio(cr <- request_signal(req$context, "test", timeout = 500, keep.raw = TRUE, cv = cv))
nanotestaio(cr <- recv_aio_signal(rep, timeout = 500, keep.raw = TRUE, cv = cv))
nanotest(is.raw(call_aio(cr)$raw))
nanotestaio(cr <- recv_aio_signal(context(rep), timeout = 500, cv = cv))
nanotestz(pipe_notify(rep, cv))
nanotestz(pipe_notify(req$socket, cv = cv, add = FALSE, remove = TRUE, flag = FALSE))
nanotesterr(request_signal(err, "test", cv = cv), "valid")
nanotesterr(recv_aio_signal(err, timeout = 500, cv = cv))
nanotesterr(request_signal(.context(req$socket), "test", cv = err), "valid")
nanotesterr(recv_aio_signal(rep, "test", cv = err), "valid")
nanotesterr(wait(err), "valid")
nanotesterr(until(err, 10), "valid")
nanotesterr(cv_value(err), "valid")
nanotesterr(cv_reset(err), "valid")
nanotesterr(cv_signal(err), "valid")
nanotesterr(pipe_notify(err, cv), "valid Socket")
nanotesterr(pipe_notify(rep, err), "valid Condition Variable")
nanotestz(req$context_close())
nanotestn(req$context_close)
nanotestz(req$close())
nanotestn(req$context)
rep$dialer <- NULL
nanotestxp(rep$dialer[[1L]])
nanotestz(close(ctx))
nanotestz(close(rep))

nanotestnano(pub <- nano("pub", listen = "inproc://ps"))
nanotestnano(sub <- nano("sub", dial = "inproc://ps", autostart = NA))
nanotestxp(cv <- cv())
nanotestxp(cv2 <- cv())
nanotestz(pipe_notify(pub$socket, cv, cv2, flag = FALSE))
nanotestnano(sub$opt(name = "sub:prefnew", value = FALSE))
nanotest(!sub$opt(name = "sub:prefnew"))
nanotesterr(sub$opt(name = "false", value = 100), "supported")
nanotesterr(sub$opt(name = "false"), "supported")
nanotesterr(sub$opt(name = "false", value = list()), "type")
nanotestnano(sub$subscribe("test"))
nanotestnano(subscribe(sub$socket, NULL))
nanotestnano(sub$unsubscribe("test"))
nanotestxp(sub$context_open())
nanotest(inherits(sub$context, "nanoContext"))
nanotestnano(sub$subscribe(12))
nanotestnano(sub$unsubscribe(12))
nanotestnano(sub$subscribe(NULL))
nanotestz(sub$context_close())
nanotestn(sub$context)
nanotestz(sub$close())
nanotestz(pub$close())
nanotest(wait(cv))
nanotest(wait(cv2))
nanotestn(cv_signal(cv))
nanotest(cv_value(cv) == 1L)

nanotestnano(surv <- nano(protocol = "surveyor", listen = "inproc://sock1", dial = "inproc://sock2"))
nanotestp(surv)
nanotestnano(resp <- nano(protocol = "respondent", listen = "inproc://sock2", dial = "inproc://sock1"))
nanotestz(pipe_notify(surv$socket, cv, cv2, flag = TRUE))
surv$dialer <- NULL
nanotestxp(surv$dialer[[1L]])
nanotestxp(surv$listener[[1L]])
nanotestnano(surv$survey_time(5000))
nanotestxp(surv$context_open())
nanotestxp(resp$context_open())
nanotestnano(surv$survey_time(value = 2000))
nanotestz(surv$context_close())
nanotestz(resp$context_close())
nanotestz(surv$close())
nanotestz(resp$close())
nanotest(!wait(cv))
nanotest(!wait(cv2))
nanotest(is_error_value(resp$recv(keep.raw = TRUE)$raw))

nanotest(inherits(bus <- socket(protocol = "bus"), "nanoSocket"))
nanotest(inherits(push <- socket(protocol = "push"), "nanoSocket"))
nanotest(inherits(pull <- socket(protocol = "pull"), "nanoSocket"))
nanotest(inherits(survey <- nano(protocol = "surveyor"), "nanoObject"))
nanotest(inherits(respond <- nano(protocol = "respondent"), "nanoObject"))
nanotestnano(bus)
nanotestw(listen(bus, url = "test") == 3L)
nanotestw(dial(bus, url = "test") == 3L)
nanotestz(close(bus))
nanotestz(close(push))
nanotestz(close(pull))
nanotestz(survey$close())
nanotestz(respond$close())
nanotesterr(socket(protocol = "newprotocol"), "protocol")
nanotesterr(socket(dial = "test"), "argument")
nanotesterr(socket(listen = "test"), "argument")

nanotestnn(ncurl("http://www.cam.ac.uk/"))
nanotestnn(ncurl("http://www.cam.ac.uk/", follow = FALSE, response = "date"))
nanotestnn(ncurl("http://www.cam.ac.uk/", follow = FALSE, response = list("date")))
nanotestnn(ncurl("http://www.cam.ac.uk/", follow = TRUE))
nanotestnn(ncurl("http://postman-echo.com/post", convert = FALSE, method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test", response = "server", timeout = 3000L))
nanotestnn(ncurl("http://postman-echo.com/post", convert = FALSE, method = "POST", headers = list(`Content-Type` = "text/plain"), response = list("Date", "Server"), timeout = 3000))
relo <- ncurl("https://trin.cam.ac.uk/", convert = FALSE, response = "server", async = TRUE)
nanotest(is.integer(call_aio(relo)$status))
relo <- ncurl("https://trin.cam.ac.uk/", convert = FALSE, response = list("server"), async = TRUE)
nanotest(is.integer(call_aio(relo)$status))
put1 <- ncurl("http://postman-echo.com/put", async = TRUE, method = "PUT", headers = c(Authorization = "Bearer token"), data = "test", response = c("date", "server"), timeout = 3000L)
nanotest(is.integer(call_aio(put1)$status))
nanotestnn(put1$headers)
nanotest(is.null(put1$raw) || is_error_value(put1$raw))
nanotestnn(put1$data)
put2 <- ncurl("http://postman-echo.com/put", async = TRUE, method = "PUT", headers = list(Authorization = "Bearer token"), response = list("date", "server"), timeout = 3000L)
nanotestp(put2)
nanotest(is.integer(call_aio(put2)$status))
nanotest(is.null(stop_aio(put2)))
nanotest(is_error_value(ncurl("http")$raw))
nanotest(is_error_value(ncurl("http", async = TRUE)$data))
haio <- ncurl("https://i.i", async = TRUE)
nanotest(is_error_value(call_aio(haio)$raw))
nanotestp(haio$data)
sess <- ncurl_session("https://postman-echo.com/post", method = "POST", headers = c(`Content-Type` = "text/plain"), data = "test", response = "server", timeout = 3000L)
nanotestnn(sess)
nanotest(is_error_value(sess) || length(transact(sess)) == 4L)
sess <- ncurl_session("https://postman-echo.com/post", convert = FALSE, method = "POST", headers = list(`Content-Type` = "text/plain"), response = list("Date", "Server"), timeout = 3000)
nanotestnn(sess)
nanotest(is_error_value(sess) || length(transact(sess)) == 4L)
nanotest(is_error_value(sess) || close(sess) == 0L)
nanotesterr(transact(sess), "ncurlSession")
nanotestw(is_error_value(ncurl_session("https://i")))
nanotesterr(stream(dial = "wss://127.0.0.1:5555"))
nanotesterr(stream(listen = "errorValue3"), "argument")
nanotesterr(stream(), "specify")

nanotest(is.character(ver <- nng_version()) && length(ver) == 2L)
nanotest(nng_error(8L) == "Try again")
nanotest(is_nul_byte(as.raw(0L)))
nanotest(!is_nul_byte(NULL))
nanotest(!is_error_value(1L))
nanotesterr(messenger("invalidURL"), "argument")
nanotest(is.double(mclock()))
nanotestn(msleep(1L))
nanotestn(msleep(1))
nanotestn(msleep("a"))
nanotest(is.character(urlp <- parse_url("tcp://192.168.0.2:5555")) && length(urlp) == 10L)
nanotest(is.double(random()))
nanotest(length(random(2)) == 2L)
nanotest(length(random(3L)) == 3L)
nanotesterr(parse_url("tcp:/"), "argument")
nanotesterr(random("test"), "integer")
nanotesterr(device(push, pull), "closed")
nanotesterr(device(ctx, push), "s1")
nanotesterr(device(push, ctx), "s2")
for (i in c(100:103, 200:208, 226, 300:308, 400:426, 428:431, 451, 500:511))
  nanotest(is.character(status_code(i)))
nanotest(strcat("hello ", "world") == "hello world")

s <- tryCatch(stream(dial = "wss://echo.websocket.events/", textframes = TRUE), error = function(e) NULL)
if (length(s)) {
  nanotestnn(recv(s, block = 500L))
  nanotest(is.integer(send(s, "message1", block = 500L)))
  nanotestnn(recv(s, block = FALSE))
  nanotest(is.integer(send(s, "message2", block = FALSE)))
  nanotestnn(recv(s, mode = 2L, block = 100))
  nanotest(is.integer(send(s, 2L, block = 500)))
  nanotestaio(sr <- recv_aio(s, mode = "integer", keep.raw = TRUE, timeout = 500L, n = 8192L))
  nanotestw(length(call_aio(sr)[["raw"]]))
  nanotestn(stop_aio(sr))
  nanotestaio(ss <- send_aio(s, "async", timeout = 500L))
  nanotest(is.integer(call_aio(ss)[["result"]]))
  nanotestn(stop_aio(ss))
  nanotest(is.integer(send(s, 12.56, mode = "raw", block = 500L)))
  nanotestaio(sr <- recv_aio_signal(s, mode = "double", timeout = 500L, cv = cv))
  nanotestw(length(call_aio(sr)[["data"]]))
  nanotest(cv_value(cv) > 0L)
  nanotest(!wait(cv))
  nanotest(is.character(opt(s, "ws:request-headers")))
  nanotestnn(opt(s, "tcp-nodelay") <- FALSE)
  nanotesterr(recv(s, mode = "none", block = FALSE), "mode")
  nanotesterr(recv(s, mode = "c", block = FALSE), "mode")
  nanotesterr(opt(s, "none"), "supported")
  nanotestp(s)
  nanotest(is.integer(close(s)))
}

nanotestnano(s <- socket("bus", listen = "inproc://nanolock"))
nanotestnano(s1 <- socket("bus", dial = "inproc://nanolock"))
nanotestz(lock(s))
nanotestnano(s2 <- socket("bus", dial = "inproc://nanolock"))
nanotestaio(send_aio(s, "test"))
nanotestnn(recv(s1, block = 500))
nanotest(is_error_value(recv(s2)))
nanotestz(unlock(s))
nanotesterr(unlock(cv), "valid Socket")
nanotestxp(cv <- cv())
nanotestz(pipe_notify(s, cv = cv, flag = FALSE))
nanotestnano(s3 <- socket("bus", dial = "inproc://nanolock"))
nanotestz(send(s, "test", block = 500))
nanotestnn(recv(s3, block = 500))
nanotestz(lock(s, cv = cv))
nanotesterr(lock(cv), "valid Socket")
nanotesterr(lock(s, cv = s), "valid Condition Variable")
nanotestnano(s4 <- socket("bus", dial = "inproc://nanolock"))
nanotestaio(send_aio(s, "test"))
nanotest(is_error_value(recv(s4)))
nanotestz(close(s))
nanotestz(close(s1))
nanotestz(close(s2))
nanotestz(close(s3))
nanotestz(close(s4))

nanotest(nanonext:::.DollarNames.ncurlAio(NULL, "sta") == "status")
nanotest(nanonext:::.DollarNames.recvAio(NULL, "dat") == "data")
nanotest(nanonext:::.DollarNames.sendAio(NULL, "r") == "result")
nanotest(length(nanonext:::.DollarNames.nano(NULL)) == 0L)

fakesock <- `class<-`(new.env(), "nanoSocket")
nanotesterr(dial(fakesock), "valid Socket")
nanotesterr(dial(fakesock, autostart = FALSE), "valid Socket")
nanotesterr(listen(fakesock), "valid Socket")
nanotesterr(listen(fakesock, autostart = FALSE), "valid Socket")
nanotesterr(context(fakesock), "valid Socket")
nanotesterr(.context(fakesock), "valid Socket")
nanotesterr(stat(fakesock, "pipes"), "valid Socket")
nanotesterr(close(fakesock), "valid Socket")
nanotest(!.unresolved(fakesock))
fakectx <- `class<-`("test", "nanoContext")
nanotest(!.unresolved(fakectx))
nanotesterr(request(fakectx, data = "test"), "valid Context")
nanotesterr(subscribe(fakectx, NULL), "valid")
nanotesterr(close(fakectx), "valid Context")
fakestream <- `class<-`("test", "nanoStream")
nanotestp(fakestream)
fakesession <- `class<-`("test", "ncurlSession")
nanotestp(fakesession)
nanotesterr(transact(fakesession), "valid")
nanotesterr(close(fakesession), "valid")
nanotesterr(send(fakestream, "test"), "valid")
nanotesterr(send_aio(fakestream, "test"), "valid")
nanotesterr(recv(fakestream), "valid")
nanotesterr(recv_aio(fakestream), "valid")
nanotesterr(opt(fakestream, name = "test") <- "test", "valid")
nanotesterr(opt(fakestream, name = "test"), "valid")
nanotesterr(close(fakestream), "active Stream")
fakedial <- `class<-`("test", "nanoDialer")
nanotesterr(start(fakedial), "valid Dialer")
nanotesterr(close(fakedial), "valid Dialer")
fakelist <- `class<-`("test", "nanoListener")
nanotesterr(start(fakelist), "valid Listener")
nanotesterr(close(fakelist), "valid Listener")
unres <- `class<-`(NA, "unresolvedValue")
nanotestp(unres)
nanotest(!unresolved(unres))
nanotest(identical(call_aio("a"), "a"))
nanotestn(stop_aio("a"))

nanotest(sha256("test") == "9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08")
nanotest(length(sha256(c("one", "two"), key = "PRIVATE_key", convert = FALSE)) == 32L)
nanotest(nchar(sha512(c(1.1, 2.2), as.raw(1L))) == 128L)
nanotest(length(sha512("testing", convert = FALSE)) == 64L)
nanotest(length(sha384(as.list(random(1e4L)), "KEY", convert = FALSE)) == 48L)
nanotest(nchar(sha384(7000L, key = NULL, convert = TRUE)) == 96L)
nanotest(length(sha224(c("one", "two"), key = "PRIVATE_key", convert = FALSE)) == 28L)
nanotest(sha224(as.raw(0L)) == "fff9292b4201617bdc4d3053fce02734166a683d7d858a7f5f59b073")
nanotest(length(sha1("testingnoncrypto", convert = FALSE)) == 20L)
nanotest(nchar(sha1(c(1, 2), key = "secret")) == 40L)
nanotest(is.raw(sha1(quote(a + 2), convert = FALSE)))
nanotest(is.character(sha256(quote(a))))
nanotest(base64enc("test") == "dGVzdA==")
nanotest(base64dec(base64enc("test")) == "test")
nanotest(is.raw(base64enc(data.frame(), convert = FALSE)))
nanotest(is.raw(base64dec(base64enc(as.raw(c(1L, 2L)), convert = FALSE), convert = FALSE)))
nanotest(is.integer(base64dec(base64enc(c(1L, 2L)), convert = NA)))
nanotesterr(base64dec("__"), "not valid base64")

k <- new.env()
v <- "value"
nanotest(typeof(w <- weakref(k, v)) == "weakref")
nanotest(identical(weakref_key(w), k))
nanotest(identical(weakref_value(w), v))
rm(v)
nanotest(weakref_value(w) == "value")

file <- tempfile()
pem <- "-----BEGIN CERTIFICATE----- -----END CERTIFICATE-----"
cat(pem, file = file)
nanotesterr(tls_config(client = file), "Cryptographic error")
nanotesterr(tls_config(server = file), "Cryptographic error")
nanotesterr(tls_config(client = c(pem, pem)), "Cryptographic error")
nanotesterr(tls_config(server = c(pem, pem)), "Cryptographic error")
unlink(file)
nanotest(is.list(cert <- write_cert(cn = "127.0.0.1")))
nanotest(length(cert) == 2L && is.character(cert[[1L]]))
nanotest(identical(names(cert), c("server", "client")))
nanotestxp(tls <- tls_config(client = cert$client))
nanotest(inherits(tls, "tlsConfig"))
nanotestp(tls)
nanotest(is_error_value(ncurl("https://www.cam.ac.uk/", tls = tls)$status))
nanotest(is_error_value(call_aio(ncurl("https://www.cam.ac.uk/", async = TRUE, tls = tls))$status))
nanotestxp(s <- socket(listen = "tls+tcp://127.0.0.1:5556", tls = tls_config(server = cert$server)))
nanotestxp(s1 <- socket(dial = "tls+tcp://127.0.0.1:5556", tls = tls))
nanotestw(dial(s, url = "tls+tcp://[", tls = tls, error = FALSE) > 0)
nanotestw(listen(s, url = "tls+tcp://[", tls = tls, error = FALSE) > 0)
nanotestz(close(s1))
nanotestz(close(s))
nanotestxp(tls <- tls_config())
nanotestxp(s <- socket(listen = "wss://127.0.0.1:5557", tls = tls))
nanotestz(close(s))
